/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.ClassLoaderThreadFactory;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolFactory;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jgroups.protocols.TP;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class TransportConfigurationServiceConfigurator<T extends TP>
extends AbstractProtocolConfigurationServiceConfigurator<T, TransportConfiguration<T>>
implements TransportConfiguration<T> {
    private final ServiceNameProvider provider;
    private final SupplierDependency<ThreadPoolFactory> threadPoolFactory;
    private volatile SupplierDependency<SocketBinding> socketBinding;
    private volatile SupplierDependency<SocketBinding> diagnosticsSocketBinding;
    private volatile TransportConfiguration.Topology topology = null;

    public TransportConfigurationServiceConfigurator(PathAddress address) {
        super(address.getLastElement().getValue());
        this.provider = new SingletonProtocolServiceNameProvider(address);
        this.threadPoolFactory = new ServiceSupplierDependency((ServiceNameProvider)new ThreadPoolServiceNameProvider(address, ThreadPoolResourceDefinition.DEFAULT.getPathElement()));
    }

    public ServiceName getServiceName() {
        return this.provider.getServiceName();
    }

    @Override
    public TransportConfiguration<T> get() {
        return this;
    }

    @Override
    public <B> ServiceBuilder<B> register(ServiceBuilder<B> builder) {
        return super.register(new CompositeDependency(new Dependency[]{this.threadPoolFactory, this.socketBinding, this.diagnosticsSocketBinding}).register(builder));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.socketBinding = new ServiceSupplierDependency(CommonUnaryRequirement.SOCKET_BINDING.getServiceName(context, TransportResourceDefinition.Attribute.SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asString()));
        String diagnosticsSocketBinding = TransportResourceDefinition.Attribute.DIAGNOSTICS_SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.diagnosticsSocketBinding = diagnosticsSocketBinding != null ? new ServiceSupplierDependency(CommonUnaryRequirement.SOCKET_BINDING.getServiceName(context, diagnosticsSocketBinding)) : new SimpleSupplierDependency(null);
        final ModelNode machine = TransportResourceDefinition.Attribute.MACHINE.resolveModelAttribute((ExpressionResolver)context, model);
        final ModelNode rack = TransportResourceDefinition.Attribute.RACK.resolveModelAttribute((ExpressionResolver)context, model);
        final ModelNode site = TransportResourceDefinition.Attribute.SITE.resolveModelAttribute((ExpressionResolver)context, model);
        if (site.isDefined() || rack.isDefined() || machine.isDefined()) {
            this.topology = new TransportConfiguration.Topology(){

                public String getMachine() {
                    return machine.asStringOrNull();
                }

                public String getRack() {
                    return rack.asStringOrNull();
                }

                public String getSite() {
                    return site.asStringOrNull();
                }
            };
        }
        return super.configure(context, model);
    }

    public Map<String, SocketBinding> getSocketBindings() {
        TreeMap<String, SocketBinding> bindings = new TreeMap<String, SocketBinding>();
        SocketBinding binding = this.getSocketBinding();
        for (String serviceName : Set.of("jgroups.udp.mcast_sock", "jgroups.udp.sock", "jgroups.tcp.server", "jgroups.nio.client", "jgroups.nio.server", "jgroups.tunnel.ucast_sock")) {
            bindings.put(serviceName, binding);
        }
        bindings.put("jgroups.tp.diag.mcast_sock", (SocketBinding)this.diagnosticsSocketBinding.get());
        return bindings;
    }

    @Override
    public void accept(T protocol) {
        SocketBinding binding = this.getSocketBinding();
        InetSocketAddress socketAddress = binding.getSocketAddress();
        protocol.setBindAddress(socketAddress.getAddress());
        protocol.setBindPort(socketAddress.getPort());
        List clientMappings = binding.getClientMappings();
        if (!clientMappings.isEmpty()) {
            ClientMapping mapping = (ClientMapping)clientMappings.get(0);
            try {
                protocol.setExternalAddr(InetAddress.getByName(mapping.getDestinationAddress()));
                protocol.setExternalPort(mapping.getDestinationPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        protocol.setThreadFactory((ThreadFactory)new ClassLoaderThreadFactory((ThreadFactory)new DefaultThreadFactory("jgroups", false, true), JChannelFactory.class.getClassLoader()));
        protocol.setThreadPool((Executor)((ThreadPoolFactory)this.threadPoolFactory.get()).apply(protocol.getThreadFactory()));
        SocketBinding diagnosticsBinding = (SocketBinding)this.diagnosticsSocketBinding.get();
        if (diagnosticsBinding != null) {
            DiagnosticsHandler handler = new DiagnosticsHandler(protocol.getLog(), protocol.getSocketFactory(), protocol.getThreadFactory());
            InetSocketAddress address = diagnosticsBinding.getSocketAddress();
            handler.setBindAddress(address.getAddress());
            if (diagnosticsBinding.getMulticastAddress() != null) {
                handler.setMcastAddress(diagnosticsBinding.getMulticastAddress());
                handler.setPort(diagnosticsBinding.getMulticastPort());
            } else {
                handler.setPort(diagnosticsBinding.getPort());
            }
            try {
                protocol.setDiagnosticsHandler(handler);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public TransportConfiguration.Topology getTopology() {
        return this.topology;
    }

    public SocketBinding getSocketBinding() {
        return (SocketBinding)this.socketBinding.get();
    }
}

