/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemSchema;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.subsystem.ClusteringSubsystemTest;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.Versioned;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.service.UnaryRequirement;

@RunWith(value=Parameterized.class)
public class JGroupsSubsystemTestCase
extends ClusteringSubsystemTest<JGroupsSubsystemSchema> {
    private final JGroupsSubsystemSchema schema;

    @Parameterized.Parameters
    public static Iterable<JGroupsSubsystemSchema> parameters() {
        return EnumSet.allOf(JGroupsSubsystemSchema.class);
    }

    public JGroupsSubsystemTestCase(JGroupsSubsystemSchema schema) {
        super("jgroups", (Extension)new JGroupsExtension(), (SubsystemSchema)schema, "subsystem-jgroups-%d_%d.xml", "schema/jboss-as-jgroups_%d_%d.xsd");
        this.schema = schema;
    }

    private KernelServices buildKernelServices() throws Exception {
        return this.buildKernelServices(this.getSubsystemXml());
    }

    private KernelServices buildKernelServices(String xml) throws Exception {
        return this.createKernelServicesBuilder(xml).build();
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(this.createAdditionalInitialization());
    }

    private KernelServicesBuilder createKernelServicesBuilder(String xml) throws XMLStreamException {
        return this.createKernelServicesBuilder().setSubsystemXml(xml);
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((UnaryRequirement)CommonUnaryRequirement.SOCKET_BINDING, new String[]{"jgroups-tcp", "jgroups-udp", "some-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "jgroups-client-fd"}).require((UnaryRequirement)CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING, new String[]{"node1", "node2"}).require((UnaryRequirement)CommonUnaryRequirement.KEY_STORE, new String[]{"my-key-store"}).require((UnaryRequirement)CommonUnaryRequirement.CREDENTIAL_STORE, new String[]{"my-credential-store"}).require((UnaryRequirement)CommonUnaryRequirement.DATA_SOURCE, new String[]{"ExampleDS"});
    }

    @Test
    public void testIndexedAdds() throws Exception {
        if (!this.schema.since((Versioned)JGroupsSubsystemSchema.VERSION_3_0)) {
            return;
        }
        KernelServices services = this.buildKernelServices();
        ModelNode originalSubsystemModel = services.readWholeModel().get(JGroupsSubsystemResourceDefinition.PATH.getKeyValuePair());
        ModelNode originalChannelModel = originalSubsystemModel.get(ChannelResourceDefinition.pathElement((String)"ee").getKeyValuePair());
        ModelNode originalForkModel = originalChannelModel.get(ForkResourceDefinition.pathElement((String)"web").getKeyValuePair());
        Assert.assertTrue((boolean)originalForkModel.isDefined());
        originalForkModel.protect();
        Assert.assertTrue((0 < originalForkModel.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).keys().size() ? 1 : 0) != 0);
        ModelNode originalStackModel = originalSubsystemModel.get(StackResourceDefinition.pathElement((String)"maximal").getKeyValuePair());
        Assert.assertTrue((boolean)originalStackModel.isDefined());
        originalStackModel.protect();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        PathAddress forkAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement((String)"ee")}).append(new PathElement[]{ForkResourceDefinition.pathElement((String)"web")});
        PathAddress stackAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement((String)"maximal")});
        ModelNode add = Util.createAddOperation((PathAddress)forkAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)"MERGE3")}), (int)0);
        ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(add, new InputStream[0]));
        ModelNode subsystemModel = services.readWholeModel().get(JGroupsSubsystemResourceDefinition.PATH.getKeyValuePair());
        ModelNode channelModel = subsystemModel.get(ChannelResourceDefinition.pathElement((String)"ee").getKeyValuePair());
        ModelNode forkModel = channelModel.get(ForkResourceDefinition.pathElement((String)"web").getKeyValuePair());
        Assert.assertEquals((long)(originalForkModel.keys().size() + 1), (long)forkModel.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).keys().size());
        Assert.assertEquals((Object)"MERGE3", forkModel.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).keys().iterator().next());
        ModelNode remove = Util.createRemoveOperation((PathAddress)stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)"FD")}));
        ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(remove, new InputStream[0]));
        add = Util.createAddOperation((PathAddress)stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)"FD")}), (int)3);
        ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(add, new InputStream[0]));
        subsystemModel = services.readWholeModel().get(JGroupsSubsystemResourceDefinition.PATH.getKeyValuePair());
        ModelNode stackModel = subsystemModel.get(StackResourceDefinition.pathElement((String)"maximal").getKeyValuePair());
        Assert.assertEquals((Object)originalStackModel, (Object)stackModel);
    }
}

