/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.clustering.jgroups.SocketFactory;
import org.jboss.as.network.ManagedServerSocketFactory;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ManagedSocketFactoryTestCase {
    private final SocketBindingManager manager = (SocketBindingManager)Mockito.mock(SocketBindingManager.class);
    private final SelectorProvider provider = (SelectorProvider)Mockito.mock(SelectorProvider.class);
    private final SocketFactory subject = new ManagedSocketFactory(this.provider, this.manager, Map.of("known-service", new SocketBinding("binding", 0, false, null, 0, null, this.manager, List.of())));

    @Test
    public void createSocket() throws IOException {
        this.createSocket("known-service", "binding");
        this.createSocket("unknown-service", null);
    }

    private void createSocket(String serviceName, String bindingName) throws IOException {
        InetSocketAddress connectSocketAddress;
        ArgumentCaptor capturedConnectAddress;
        InetSocketAddress bindSocketAddress;
        ArgumentCaptor capturedBindAddress;
        InetSocketAddress connectSocketAddress2;
        ArgumentCaptor capturedConnectAddress2;
        org.jboss.as.network.ManagedSocketFactory factory = (org.jboss.as.network.ManagedSocketFactory)Mockito.mock(org.jboss.as.network.ManagedSocketFactory.class);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)this.manager.getSocketFactory()).thenReturn((Object)factory);
        if (bindingName != null) {
            Mockito.when((Object)factory.createSocket(bindingName)).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)factory.createSocket()).thenReturn((Object)socket);
        }
        try (Socket result = this.subject.createSocket(serviceName);){
            Assert.assertSame((Object)socket, (Object)result);
            ((Socket)Mockito.verify((Object)socket, (VerificationMode)Mockito.never())).bind((SocketAddress)ArgumentMatchers.any());
            ((Socket)Mockito.verify((Object)socket, (VerificationMode)Mockito.never())).connect((SocketAddress)ArgumentMatchers.any());
        }
        Mockito.reset((Object[])new Socket[]{socket});
        InetAddress connectAddress = InetAddress.getLocalHost();
        int connectPort = 1;
        try (Socket result = this.subject.createSocket(serviceName, connectAddress, connectPort);){
            Assert.assertSame((Object)socket, (Object)result);
            ((Socket)Mockito.verify((Object)socket, (VerificationMode)Mockito.never())).bind((SocketAddress)ArgumentMatchers.any());
            capturedConnectAddress2 = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((Socket)Mockito.verify((Object)socket)).connect((SocketAddress)capturedConnectAddress2.capture());
            connectSocketAddress2 = (InetSocketAddress)capturedConnectAddress2.getValue();
            Assert.assertEquals((Object)connectAddress, (Object)connectSocketAddress2.getAddress());
            Assert.assertEquals((long)connectPort, (long)connectSocketAddress2.getPort());
        }
        Mockito.reset((Object[])new Socket[]{socket});
        result = this.subject.createSocket(serviceName, connectAddress.getHostName(), connectPort);
        try {
            Assert.assertSame((Object)socket, (Object)result);
            ((Socket)Mockito.verify((Object)socket, (VerificationMode)Mockito.never())).bind((SocketAddress)ArgumentMatchers.any());
            capturedConnectAddress2 = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((Socket)Mockito.verify((Object)socket)).connect((SocketAddress)capturedConnectAddress2.capture());
            connectSocketAddress2 = (InetSocketAddress)capturedConnectAddress2.getValue();
            Assert.assertEquals((Object)connectAddress, (Object)connectSocketAddress2.getAddress());
            Assert.assertEquals((long)connectPort, (long)connectSocketAddress2.getPort());
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
        Mockito.reset((Object[])new Socket[]{socket});
        InetAddress bindAddress = InetAddress.getLoopbackAddress();
        int bindPort = 2;
        try (Socket result = this.subject.createSocket(serviceName, connectAddress, connectPort, bindAddress, bindPort);){
            Assert.assertSame((Object)socket, (Object)result);
            capturedBindAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((Socket)Mockito.verify((Object)socket)).bind((SocketAddress)capturedBindAddress.capture());
            bindSocketAddress = (InetSocketAddress)capturedBindAddress.getValue();
            Assert.assertEquals((Object)bindAddress, (Object)bindSocketAddress.getAddress());
            Assert.assertEquals((long)bindPort, (long)bindSocketAddress.getPort());
            capturedConnectAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((Socket)Mockito.verify((Object)socket)).connect((SocketAddress)capturedConnectAddress.capture());
            connectSocketAddress = (InetSocketAddress)capturedConnectAddress.getValue();
            Assert.assertEquals((Object)connectAddress, (Object)connectSocketAddress.getAddress());
            Assert.assertEquals((long)connectPort, (long)connectSocketAddress.getPort());
        }
        Mockito.reset((Object[])new Socket[]{socket});
        result = this.subject.createSocket(serviceName, connectAddress.getHostName(), connectPort, bindAddress, bindPort);
        try {
            Assert.assertSame((Object)socket, (Object)result);
            capturedBindAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((Socket)Mockito.verify((Object)socket)).bind((SocketAddress)capturedBindAddress.capture());
            bindSocketAddress = (InetSocketAddress)capturedBindAddress.getValue();
            Assert.assertEquals((Object)bindAddress, (Object)bindSocketAddress.getAddress());
            Assert.assertEquals((long)bindPort, (long)bindSocketAddress.getPort());
            capturedConnectAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((Socket)Mockito.verify((Object)socket)).connect((SocketAddress)capturedConnectAddress.capture());
            connectSocketAddress = (InetSocketAddress)capturedConnectAddress.getValue();
            Assert.assertEquals((Object)connectAddress, (Object)connectSocketAddress.getAddress());
            Assert.assertEquals((long)connectPort, (long)connectSocketAddress.getPort());
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    @Test
    public void createServerSocket() throws IOException {
        this.createServerSocket("known-service", "binding");
        this.createServerSocket("unknown-service", null);
    }

    private void createServerSocket(String serviceName, String bindingName) throws IOException {
        ManagedServerSocketFactory factory = (ManagedServerSocketFactory)Mockito.mock(ManagedServerSocketFactory.class);
        ServerSocket socket = (ServerSocket)Mockito.mock(ServerSocket.class);
        Mockito.when((Object)this.manager.getServerSocketFactory()).thenReturn((Object)factory);
        if (bindingName != null) {
            Mockito.when((Object)factory.createServerSocket(bindingName)).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)factory.createServerSocket()).thenReturn((Object)socket);
        }
        try (ServerSocket result = this.subject.createServerSocket(serviceName);){
            Assert.assertSame((Object)socket, (Object)result);
            ((ServerSocket)Mockito.verify((Object)socket, (VerificationMode)Mockito.never())).bind((SocketAddress)ArgumentMatchers.any());
        }
        Mockito.reset((Object[])new ServerSocket[]{socket});
        int bindPort = 1;
        try (ServerSocket result = this.subject.createServerSocket(serviceName, bindPort);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((ServerSocket)Mockito.verify((Object)socket)).bind((SocketAddress)capturedAddress.capture(), ArgumentMatchers.eq((int)0));
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertTrue((boolean)address.getAddress().isAnyLocalAddress());
            Assert.assertEquals((long)bindPort, (long)address.getPort());
        }
        Mockito.reset((Object[])new ServerSocket[]{socket});
        int backlog = 10;
        try (ServerSocket result = this.subject.createServerSocket(serviceName, bindPort, backlog);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((ServerSocket)Mockito.verify((Object)socket)).bind((SocketAddress)capturedAddress.capture(), ArgumentMatchers.eq((int)backlog));
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertTrue((boolean)address.getAddress().isAnyLocalAddress());
            Assert.assertEquals((long)bindPort, (long)address.getPort());
        }
        Mockito.reset((Object[])new ServerSocket[]{socket});
        InetAddress bindAddress = InetAddress.getLoopbackAddress();
        try (ServerSocket result = this.subject.createServerSocket(serviceName, bindPort, backlog, bindAddress);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            ((ServerSocket)Mockito.verify((Object)socket)).bind((SocketAddress)capturedAddress.capture(), ArgumentMatchers.eq((int)backlog));
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertEquals((Object)bindAddress, (Object)address.getAddress());
            Assert.assertEquals((long)bindPort, (long)address.getPort());
        }
        Mockito.reset((Object[])new ServerSocket[]{socket});
    }

    @Test
    public void createDatagramSocket() throws IOException {
        this.createDatagramSocket("known-service", "binding");
        this.createDatagramSocket("unknown-service", null);
    }

    private void createDatagramSocket(String serviceName, String bindingName) throws IOException {
        DatagramSocket socket = (DatagramSocket)Mockito.mock(DatagramSocket.class);
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createDatagramSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (DatagramSocket result = this.subject.createDatagramSocket(serviceName);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((SocketAddress)capturedAddress.capture());
            }
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertTrue((boolean)address.getAddress().isAnyLocalAddress());
            Assert.assertEquals((long)0L, (long)address.getPort());
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        int bindPort = 1;
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createDatagramSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (DatagramSocket result = this.subject.createDatagramSocket(serviceName, bindPort);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((SocketAddress)capturedAddress.capture());
            }
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertTrue((boolean)address.getAddress().isAnyLocalAddress());
            Assert.assertEquals((long)bindPort, (long)address.getPort());
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        InetAddress bindAddress = InetAddress.getLocalHost();
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createDatagramSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (DatagramSocket result = this.subject.createDatagramSocket(serviceName, bindPort, bindAddress);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((SocketAddress)capturedAddress.capture());
            }
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertSame((Object)bindAddress, (Object)address.getAddress());
            Assert.assertEquals((long)bindPort, (long)address.getPort());
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName))).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createDatagramSocket()).thenReturn((Object)socket);
        }
        result = this.subject.createDatagramSocket(serviceName, null);
        try {
            Assert.assertSame((Object)socket, (Object)result);
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        InetSocketAddress socketAddress = new InetSocketAddress(bindAddress, bindPort);
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createDatagramSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (DatagramSocket result = this.subject.createDatagramSocket(serviceName, (SocketAddress)socketAddress);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(SocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createDatagramSocket((SocketAddress)capturedAddress.capture());
            }
            Assert.assertSame((Object)socketAddress, (Object)capturedAddress.getValue());
        }
    }

    @Test
    public void createMulticastSocket() throws IOException {
        this.createMulticastSocket("known-service", "binding");
        this.createMulticastSocket("unknown-service", null);
    }

    private void createMulticastSocket(String serviceName, String bindingName) throws IOException {
        MulticastSocket socket = (MulticastSocket)Mockito.mock(MulticastSocket.class);
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createMulticastSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (MulticastSocket result = this.subject.createMulticastSocket(serviceName);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((SocketAddress)capturedAddress.capture());
            }
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertTrue((boolean)address.getAddress().isAnyLocalAddress());
            Assert.assertEquals((long)0L, (long)address.getPort());
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        int bindPort = 1;
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createMulticastSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (MulticastSocket result = this.subject.createMulticastSocket(serviceName, bindPort);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((SocketAddress)capturedAddress.capture());
            }
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertTrue((boolean)address.getAddress().isAnyLocalAddress());
            Assert.assertEquals((long)bindPort, (long)address.getPort());
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        InetAddress bindAddress = InetAddress.getLocalHost();
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createMulticastSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (MulticastSocket result = this.subject.createMulticastSocket(serviceName, bindPort, bindAddress);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(InetSocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((SocketAddress)capturedAddress.capture());
            }
            InetSocketAddress address = (InetSocketAddress)capturedAddress.getValue();
            Assert.assertSame((Object)bindAddress, (Object)address.getAddress());
            Assert.assertEquals((long)bindPort, (long)address.getPort());
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName))).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createMulticastSocket()).thenReturn((Object)socket);
        }
        result = this.subject.createMulticastSocket(serviceName, null);
        try {
            Assert.assertSame((Object)socket, (Object)result);
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
        Mockito.reset((Object[])new Object[]{socket, this.manager});
        InetSocketAddress socketAddress = new InetSocketAddress(bindAddress, bindPort);
        if (bindingName != null) {
            Mockito.when((Object)this.manager.createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        } else {
            Mockito.when((Object)this.manager.createMulticastSocket((SocketAddress)ArgumentMatchers.any())).thenReturn((Object)socket);
        }
        try (MulticastSocket result = this.subject.createMulticastSocket(serviceName, (SocketAddress)socketAddress);){
            Assert.assertSame((Object)socket, (Object)result);
            ArgumentCaptor capturedAddress = ArgumentCaptor.forClass(SocketAddress.class);
            if (bindingName != null) {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((String)ArgumentMatchers.eq((Object)bindingName), (SocketAddress)capturedAddress.capture());
            } else {
                ((SocketBindingManager)Mockito.verify((Object)this.manager)).createMulticastSocket((SocketAddress)capturedAddress.capture());
            }
            Assert.assertSame((Object)socketAddress, (Object)capturedAddress.getValue());
        }
    }

    @Test
    public void createSocketChannel() throws IOException {
        this.createSocketChannel("known-service", "binding");
        this.createSocketChannel("unknown-service", null);
    }

    private void createSocketChannel(String serviceName, String bindingName) throws IOException {
        SocketBindingManager.NamedManagedBindingRegistry namedRegistry = (SocketBindingManager.NamedManagedBindingRegistry)Mockito.mock(SocketBindingManager.NamedManagedBindingRegistry.class);
        SocketBindingManager.UnnamedBindingRegistry unnamedRegistry = (SocketBindingManager.UnnamedBindingRegistry)Mockito.mock(SocketBindingManager.UnnamedBindingRegistry.class);
        Mockito.when((Object)this.manager.getNamedRegistry()).thenReturn((Object)namedRegistry);
        Mockito.when((Object)this.manager.getUnnamedRegistry()).thenReturn((Object)unnamedRegistry);
        Closeable namedRegistration = (Closeable)Mockito.mock(Closeable.class);
        Closeable unnamedRegistration = (Closeable)Mockito.mock(Closeable.class);
        try (SocketChannel channel = SocketChannel.open();){
            Mockito.when((Object)this.provider.openSocketChannel()).thenReturn((Object)channel);
            Mockito.when((Object)namedRegistry.registerChannel((String)ArgumentMatchers.eq((Object)bindingName), (SocketChannel)ArgumentMatchers.same((Object)channel))).thenReturn((Object)namedRegistration);
            Mockito.when((Object)unnamedRegistry.registerChannel((SocketChannel)ArgumentMatchers.same((Object)channel))).thenReturn((Object)unnamedRegistration);
            SocketChannel result = this.subject.createSocketChannel(serviceName);
            Assert.assertSame((Object)channel, (Object)result);
            this.subject.close(result);
            ((Closeable)Mockito.verify((Object)(bindingName != null ? namedRegistration : unnamedRegistration))).close();
            ((Closeable)Mockito.verify((Object)(bindingName == null ? namedRegistration : unnamedRegistration), (VerificationMode)Mockito.never())).close();
        }
    }

    @Test
    public void createServerSocketChannel() throws IOException {
        this.createServerSocketChannel("known-service", "binding");
        this.createServerSocketChannel("unknown-service", null);
    }

    private void createServerSocketChannel(String serviceName, String bindingName) throws IOException {
        SocketBindingManager.NamedManagedBindingRegistry namedRegistry = (SocketBindingManager.NamedManagedBindingRegistry)Mockito.mock(SocketBindingManager.NamedManagedBindingRegistry.class);
        SocketBindingManager.UnnamedBindingRegistry unnamedRegistry = (SocketBindingManager.UnnamedBindingRegistry)Mockito.mock(SocketBindingManager.UnnamedBindingRegistry.class);
        Mockito.when((Object)this.manager.getNamedRegistry()).thenReturn((Object)namedRegistry);
        Mockito.when((Object)this.manager.getUnnamedRegistry()).thenReturn((Object)unnamedRegistry);
        Closeable namedRegistration = (Closeable)Mockito.mock(Closeable.class);
        Closeable unnamedRegistration = (Closeable)Mockito.mock(Closeable.class);
        try (ServerSocketChannel channel = ServerSocketChannel.open();){
            Mockito.when((Object)this.provider.openServerSocketChannel()).thenReturn((Object)channel);
            Mockito.when((Object)namedRegistry.registerChannel((String)ArgumentMatchers.eq((Object)bindingName), (ServerSocketChannel)ArgumentMatchers.same((Object)channel))).thenReturn((Object)namedRegistration);
            Mockito.when((Object)unnamedRegistry.registerChannel((ServerSocketChannel)ArgumentMatchers.same((Object)channel))).thenReturn((Object)unnamedRegistration);
            ServerSocketChannel result = this.subject.createServerSocketChannel(serviceName);
            Assert.assertSame((Object)channel, (Object)result);
            this.subject.close(result);
            ((Closeable)Mockito.verify((Object)(bindingName != null ? namedRegistration : unnamedRegistration))).close();
            ((Closeable)Mockito.verify((Object)(bindingName == null ? namedRegistration : unnamedRegistration), (VerificationMode)Mockito.never())).close();
        }
    }

    @Test
    public void closeSocket() throws IOException {
        Socket socket = (Socket)Mockito.mock(Socket.class);
        this.subject.close(socket);
        ((Socket)Mockito.verify((Object)socket)).close();
    }

    @Test
    public void closeServerSocket() throws IOException {
        ServerSocket socket = (ServerSocket)Mockito.mock(ServerSocket.class);
        this.subject.close(socket);
        ((ServerSocket)Mockito.verify((Object)socket)).close();
    }

    @Test
    public void closeDatagramSocket() {
        DatagramSocket socket = (DatagramSocket)Mockito.mock(DatagramSocket.class);
        this.subject.close(socket);
        ((DatagramSocket)Mockito.verify((Object)socket)).close();
    }

    @Test
    public void closeMulticastSocket() {
        MulticastSocket socket = (MulticastSocket)Mockito.mock(MulticastSocket.class);
        this.subject.close((DatagramSocket)socket);
        ((MulticastSocket)Mockito.verify((Object)socket)).close();
    }
}

