/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.List;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jgroups.conf.ClassConfigurator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.service.UnaryRequirement;

@RunWith(value=Parameterized.class)
public class JGroupsTransformersTestCase
extends OperationTestCaseBase {
    ModelTestControllerVersion version;

    @Parameterized.Parameters
    public static Iterable<ModelTestControllerVersion> parameters() {
        return EnumSet.of(ModelTestControllerVersion.EAP_7_4_0, ModelTestControllerVersion.EAP_8_0_0);
    }

    public JGroupsTransformersTestCase(ModelTestControllerVersion version) {
        this.version = version;
    }

    private static String formatArtifact(String pattern, ModelTestControllerVersion version) {
        return String.format(pattern, version.getMavenGavVersion());
    }

    private static JGroupsSubsystemModel getModelVersion(ModelTestControllerVersion controllerVersion) {
        switch (controllerVersion) {
            case EAP_7_4_0: {
                return JGroupsSubsystemModel.VERSION_8_0_0;
            }
            case EAP_8_0_0: {
                return JGroupsSubsystemModel.VERSION_10_0_0;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String[] getDependencies(ModelTestControllerVersion version) {
        switch (version) {
            case EAP_7_4_0: {
                return new String[]{JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-extension:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-api:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-common:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-spi:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-server:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-service:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-spi:%s", version)};
            }
            case EAP_8_0_0: {
                return new String[]{JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-extension:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-common:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-spi:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-server-service:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-server-spi:%s", version), JGroupsTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-service:%s", version)};
            }
        }
        throw new IllegalArgumentException();
    }

    private static AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((UnaryRequirement)CommonUnaryRequirement.SOCKET_BINDING, new String[]{"jgroups-tcp", "jgroups-udp", "jgroups-udp-fd", "some-binding", "client-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "jgroups-client-fd", "jgroups-state-xfr"}).require((UnaryRequirement)CommonUnaryRequirement.KEY_STORE, new String[]{"my-key-store"}).require((UnaryRequirement)CommonUnaryRequirement.CREDENTIAL_STORE, new String[]{"my-credential-store"});
    }

    @Test
    public void testTransformations() throws Exception {
        this.testTransformations(this.version);
    }

    private void testTransformations(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = JGroupsTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = JGroupsTransformersTestCase.getDependencies(controller);
        String subsystemXmlResource = String.format("jgroups-transform-%d_%d_%d.xml", version.getMajor(), version.getMinor(), version.getMicro());
        KernelServicesBuilder builder = this.createKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization()).setSubsystemXmlResource(subsystemXmlResource);
        builder.createLegacyKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization(), controller, version).addMavenResourceURL(dependencies).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addSingleChildFirstClass(new Class[]{ClassConfigurator.class}).skipReverseControllerCheck().dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        this.checkSubsystemModelTransformation(services, version, null, false);
    }

    @Test
    public void testRejections() throws Exception {
        this.testRejections(this.version);
    }

    private void testRejections(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = JGroupsTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = JGroupsTransformersTestCase.getDependencies(controller);
        KernelServicesBuilder builder = this.createKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization());
        builder.createLegacyKernelServicesBuilder(JGroupsTransformersTestCase.createAdditionalInitialization(), controller, version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(dependencies).addSingleChildFirstClass(new Class[]{ClassConfigurator.class}).dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List operations = builder.parseXmlResource("jgroups-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)version, (List)operations, (FailedOperationTransformationConfig)JGroupsTransformersTestCase.createFailedOperationTransformationConfig(version));
    }

    private static FailedOperationTransformationConfig createFailedOperationTransformationConfig(ModelVersion version) {
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        if (JGroupsSubsystemModel.VERSION_8_0_0.requiresTransformation(version)) {
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement((String)"credentialReference1")}).append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)"SYM_ENCRYPT")}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        return config;
    }
}

