/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.network.SocketBindingManager;
import org.jgroups.util.SocketFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ManagedSocketFactoryTest {
    private SocketFactory factory = (SocketFactory)Mockito.mock(SocketFactory.class);
    private SocketBindingManager manager = (SocketBindingManager)Mockito.mock(SocketBindingManager.class);
    private SocketBindingManager.UnnamedBindingRegistry registry = (SocketBindingManager.UnnamedBindingRegistry)Mockito.mock(SocketBindingManager.UnnamedBindingRegistry.class);
    private ManagedSocketFactory subject = new ManagedSocketFactory(this.factory, this.manager);

    @Before
    public void setUp() {
        Mockito.when((Object)this.manager.getUnnamedRegistry()).thenReturn((Object)this.registry);
    }

    @Test
    public void createSocket() throws IOException {
        Socket socket1 = new Socket();
        Socket socket2 = new Socket();
        Socket socket3 = new Socket();
        Socket socket4 = new Socket();
        Socket socket5 = new Socket();
        InetAddress localhost = InetAddress.getLocalHost();
        Mockito.when((Object)this.factory.createSocket("test")).thenReturn((Object)socket1);
        Mockito.when((Object)this.factory.createSocket("test", localhost, 1)).thenReturn((Object)socket2);
        Mockito.when((Object)this.factory.createSocket("test", "host", 1)).thenReturn((Object)socket3);
        Mockito.when((Object)this.factory.createSocket("test", localhost, 1, localhost, 2)).thenReturn((Object)socket4);
        Mockito.when((Object)this.factory.createSocket("test", "host", 1, localhost, 2)).thenReturn((Object)socket5);
        Socket result1 = this.subject.createSocket("test");
        Socket result2 = this.subject.createSocket("test", localhost, 1);
        Socket result3 = this.subject.createSocket("test", "host", 1);
        Socket result4 = this.subject.createSocket("test", localhost, 1, localhost, 2);
        Socket result5 = this.subject.createSocket("test", "host", 1, localhost, 2);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket1);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket2);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket3);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket4);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket5);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
        Assert.assertSame((Object)socket4, (Object)result4);
        Assert.assertSame((Object)socket5, (Object)result5);
    }

    @Test
    public void createServerSocket() throws IOException {
        ServerSocket socket1 = new ServerSocket();
        ServerSocket socket2 = new ServerSocket();
        ServerSocket socket3 = new ServerSocket();
        ServerSocket socket4 = new ServerSocket();
        InetAddress localhost = InetAddress.getLocalHost();
        Mockito.when((Object)this.factory.createServerSocket("test")).thenReturn((Object)socket1);
        Mockito.when((Object)this.factory.createServerSocket("test", 1)).thenReturn((Object)socket2);
        Mockito.when((Object)this.factory.createServerSocket("test", 1, 0)).thenReturn((Object)socket3);
        Mockito.when((Object)this.factory.createServerSocket("test", 1, 0, localhost)).thenReturn((Object)socket4);
        ServerSocket result1 = this.subject.createServerSocket("test");
        ServerSocket result2 = this.subject.createServerSocket("test", 1);
        ServerSocket result3 = this.subject.createServerSocket("test", 1, 0);
        ServerSocket result4 = this.subject.createServerSocket("test", 1, 0, localhost);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket1);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket2);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket3);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket4);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
        Assert.assertSame((Object)socket4, (Object)result4);
    }

    @Test
    public void createDatagram() throws IOException {
        DatagramSocket socket1 = new DatagramSocket();
        DatagramSocket socket2 = new DatagramSocket();
        DatagramSocket socket3 = new DatagramSocket();
        DatagramSocket socket4 = new DatagramSocket();
        InetAddress localhost = InetAddress.getLocalHost();
        InetSocketAddress socketAddress = new InetSocketAddress(localhost, 1);
        Mockito.when((Object)this.factory.createDatagramSocket("test")).thenReturn((Object)socket1);
        Mockito.when((Object)this.factory.createDatagramSocket("test", 1)).thenReturn((Object)socket2);
        Mockito.when((Object)this.factory.createDatagramSocket("test", (SocketAddress)socketAddress)).thenReturn((Object)socket3);
        Mockito.when((Object)this.factory.createDatagramSocket("test", 1, localhost)).thenReturn((Object)socket4);
        DatagramSocket result1 = this.subject.createDatagramSocket("test");
        DatagramSocket result2 = this.subject.createDatagramSocket("test", 1);
        DatagramSocket result3 = this.subject.createDatagramSocket("test", (SocketAddress)socketAddress);
        DatagramSocket result4 = this.subject.createDatagramSocket("test", 1, localhost);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket1);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket2);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket3);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket(socket4);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
        Assert.assertSame((Object)socket4, (Object)result4);
    }

    @Test
    public void createMulticastSocket() throws IOException {
        MulticastSocket socket1 = new MulticastSocket();
        MulticastSocket socket2 = new MulticastSocket();
        MulticastSocket socket3 = new MulticastSocket();
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLocalHost(), 1);
        Mockito.when((Object)this.factory.createMulticastSocket("test")).thenReturn((Object)socket1);
        Mockito.when((Object)this.factory.createMulticastSocket("test", 1)).thenReturn((Object)socket2);
        Mockito.when((Object)this.factory.createMulticastSocket("test", (SocketAddress)address)).thenReturn((Object)socket3);
        MulticastSocket result1 = this.subject.createMulticastSocket("test");
        MulticastSocket result2 = this.subject.createMulticastSocket("test", 1);
        MulticastSocket result3 = this.subject.createMulticastSocket("test", (SocketAddress)address);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket((DatagramSocket)socket1);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket((DatagramSocket)socket2);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).registerSocket((DatagramSocket)socket3);
        Assert.assertSame((Object)socket1, (Object)result1);
        Assert.assertSame((Object)socket2, (Object)result2);
        Assert.assertSame((Object)socket3, (Object)result3);
    }

    @Test
    public void closeSocket() throws IOException {
        Socket socket = new Socket();
        this.subject.close(socket);
        ((SocketFactory)Mockito.verify((Object)this.factory)).close(socket);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).unregisterSocket(socket);
    }

    @Test
    public void closeServerSocket() throws IOException {
        ServerSocket socket = new ServerSocket();
        this.subject.close(socket);
        ((SocketFactory)Mockito.verify((Object)this.factory)).close(socket);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).unregisterSocket(socket);
    }

    @Test
    public void closeDatagramSocket() throws IOException {
        DatagramSocket socket = new DatagramSocket();
        this.subject.close(socket);
        ((SocketFactory)Mockito.verify((Object)this.factory)).close(socket);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).unregisterSocket(socket);
    }

    @Test
    public void closeMulticastSocket() throws IOException {
        MulticastSocket socket = new MulticastSocket();
        this.subject.close((DatagramSocket)socket);
        ((SocketFactory)Mockito.verify((Object)this.factory)).close((DatagramSocket)socket);
        ((SocketBindingManager.UnnamedBindingRegistry)Mockito.verify((Object)this.manager.getUnnamedRegistry())).unregisterSocket((DatagramSocket)socket);
    }
}

