/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class OperationsTestCase
extends OperationTestCaseBase {
    static final ModelNode readSubsystemDefaultStackOp = OperationsTestCase.getSubsystemReadOperation("default-stack");
    static final ModelNode writeSubsystemDefaultStackOp = OperationsTestCase.getSubsystemWriteOperation("default-stack", "new-default");
    static final ModelNode addStackOp = OperationsTestCase.getProtocolStackAddOperation("maximal2");
    static final ModelNode addStackOpWithParams = OperationsTestCase.getProtocolStackAddOperationWithParameters("maximal2");
    static final ModelNode removeStackOp = OperationsTestCase.getProtocolStackRemoveOperation("maximal2");
    static final ModelNode readTransportRackOp = OperationsTestCase.getTransportReadOperation("maximal", "TCP", "rack");
    static final ModelNode writeTransportRackOp = OperationsTestCase.getTransportWriteOperation("maximal", "TCP", "rack", "new-rack");
    static final ModelNode readTransportPropertyOp = OperationsTestCase.getTransportPropertyReadOperation("maximal", "TCP", "enable_bundling");
    static final ModelNode writeTransportPropertyOp = OperationsTestCase.getTransportPropertyWriteOperation("maximal", "TCP", "enable_bundling", "false");
    static final ModelNode addTransportOp = OperationsTestCase.getTransportAddOperation("maximal2", "UDP");
    static final ModelNode addTransportOpWithProps = OperationsTestCase.getTransportAddOperationWithProperties("maximal2", "UDP");
    static final ModelNode removeTransportOp = OperationsTestCase.getTransportRemoveOperation("maximal2", "UDP");
    static final ModelNode readProtocolSocketBindingOp = OperationsTestCase.getProtocolReadOperation("maximal", "MPING", "socket-binding");
    static final ModelNode writeProtocolSocketBindingOp = OperationsTestCase.getProtocolWriteOperation("maximal", "MPING", "socket-binding", "new-socket-binding");
    static final ModelNode readProtocolPropertyOp = OperationsTestCase.getProtocolPropertyReadOperation("maximal", "MPING", "name");
    static final ModelNode writeProtocolPropertyOp = OperationsTestCase.getProtocolPropertyWriteOperation("maximal", "MPING", "name", "new-value");
    static final ModelNode addProtocolOp = OperationsTestCase.getProtocolAddOperation("maximal2", "MPING");
    static final ModelNode addProtocolOpWithProps = OperationsTestCase.getProtocolAddOperationWithProperties("maximal2", "MPING");
    static final ModelNode removeProtocolOp = OperationsTestCase.getProtocolRemoveOperation("maximal2", "MPING");

    @Test
    public void testSubsystemReadWriteOperations() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(readSubsystemDefaultStackOp, new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"maximal", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(writeSubsystemDefaultStackOp, new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(readSubsystemDefaultStackOp, new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-default", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(readTransportRackOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"rack1", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(writeTransportRackOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(readTransportRackOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteWithParameters() throws Exception {
        KernelServices services = this.buildKernelServices();
        Assert.assertTrue((String)"Could not create services", (boolean)services.isSuccessfulBoot());
        ModelNode result = services.executeOperation(addStackOpWithParams, new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(writeTransportRackOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(readTransportRackOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(readTransportPropertyOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(writeTransportPropertyOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(readTransportPropertyOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
    }

    @Test
    public void testProtocolReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(addStackOpWithParams, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(readProtocolSocketBindingOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"jgroups-mping", (Object)result.get("result").asString());
        result = services.executeOperation(writeProtocolSocketBindingOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(readProtocolSocketBindingOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-socket-binding", (Object)result.get("result").asString());
    }

    @Test
    public void testProtocolPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(readProtocolPropertyOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"value", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(writeProtocolPropertyOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(readProtocolPropertyOp, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-value", (Object)result.get("result").asString());
    }
}

