/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class TransformersTestCase
extends OperationTestCaseBase {
    private static String formatSubsystemArtifact(ModelTestControllerVersion version) {
        return TransformersTestCase.formatArtifact("org.wildfly:wildfly-clustering-jgroups:%s", version);
    }

    private static String formatLegacySubsystemArtifact(ModelTestControllerVersion version) {
        return TransformersTestCase.formatArtifact("org.jboss.as:jboss-as-clustering-jgroups:%s", version);
    }

    private static String formatArtifact(String pattern, ModelTestControllerVersion version) {
        return String.format(pattern, version.getMavenGavVersion());
    }

    @Test
    public void testTransformerAS712() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.V7_1_2_FINAL;
        this.testTransformation(JGroupsModel.VERSION_1_1_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerAS713() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.V7_1_3_FINAL;
        this.testTransformation(JGroupsModel.VERSION_1_1_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerAS720() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.V7_2_0_FINAL;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerWF800() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_0_0_FINAL;
        this.testTransformation(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testTransformerWF810() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_1_0_FINAL;
        this.testTransformation(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP600() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_0_0;
        this.testTransformation(JGroupsModel.VERSION_1_1_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP601() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_0_1;
        this.testTransformation(JGroupsModel.VERSION_1_1_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP610() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_1_0;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP611() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_1_1;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP620() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_2_0;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP630() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_3_0;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    private void testTransformation(JGroupsModel model, ModelTestControllerVersion controller, String ... mavenResourceURLs) throws Exception {
        ModelVersion version = model.getVersion();
        KernelServicesBuilder builder = this.createKernelServicesBuilder(AdditionalInitialization.MANAGEMENT).setSubsystemXmlResource("subsystem-jgroups-transform.xml");
        builder.createLegacyKernelServicesBuilder(null, controller, version).addMavenResourceURL(mavenResourceURLs).skipReverseControllerCheck();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        this.checkSubsystemModelTransformation(services, version);
    }

    @Ignore
    @Test
    @BMRule(name="Test support for expression resolution", targetClass="^org.jboss.as.controller.AbstractAddStepHandler", targetMethod="performRuntime", targetLocation="AT ENTRY", binding="context:OperationContext = $1; operation:ModelNode = $2; model:ModelNode = $3", condition="operation.hasDefined(\"name\") AND operation.hasDefined(\"value\")", action="traceln(\"resolved value = \" + org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition.VALUE.resolveModelAttribute(context,model))")
    public void testProtocolStackPropertyResolve() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices services = this.createKernelServicesBuilder(null).setSubsystemXmlResource(subsystemXml).build();
        ModelNode operation = TransformersTestCase.getTransportPropertyAddOperation("maximal", "TCP", "bundler_type", "${the_bundler_type:new}");
        ModelNode mainResult = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)mainResult.toJSONString(true), (Object)"success", (Object)mainResult.get("outcome").asString());
    }

    @Test
    public void testRejectionsAS712() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.V7_1_2_FINAL;
        this.testRejections_1_1_0(version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsAS713() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.V7_1_3_FINAL;
        this.testRejections_1_1_0(version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsAS720() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.V7_2_0_FINAL;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsWF800() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_0_0_FINAL;
        this.testRejections(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testRejectionsWF810() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_1_0_FINAL;
        this.testRejections(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP600() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_0_0;
        this.testRejections_1_1_0(version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP601() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_0_1;
        this.testRejections_1_1_0(version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP610() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_1_0;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP611() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_1_1;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP620() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_2_0;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP630() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_3_0;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    private void testRejections_1_1_0(ModelTestControllerVersion controllerVersion, String ... mavenResourceURLs) throws Exception {
        ModelVersion version = JGroupsModel.VERSION_1_1_0.getVersion();
        KernelServicesBuilder builder = this.createKernelServicesBuilder(AdditionalInitialization.MANAGEMENT);
        builder.createLegacyKernelServicesBuilder(null, controllerVersion, version).addMavenResourceURL(mavenResourceURLs).dontPersistXml().skipReverseControllerCheck();
        KernelServices mainServices = builder.build();
        Assert.assertTrue((boolean)mainServices.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)mainServices.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"jgroups")});
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)mainServices, (ModelVersion)version, (List)builder.parseXmlResource(JGroupsSchema.CURRENT.format("subsystem-jgroups-%d_%d.xml")), (FailedOperationTransformationConfig)new FailedOperationTransformationConfig().addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}), (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.RejectExpressionsConfig(new String[]{"shared"})).addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{PropertyResourceDefinition.WILDCARD_PATH}), (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.RejectExpressionsConfig(new String[]{"value"})).addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{ProtocolResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{PropertyResourceDefinition.WILDCARD_PATH}), (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.RejectExpressionsConfig(new String[]{"value"})).addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{RelayResourceDefinition.PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE).addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{RelayResourceDefinition.PATH}).append(new PathElement[]{RemoteSiteResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE));
    }

    private void testRejections(JGroupsModel model, ModelTestControllerVersion controller, String ... dependencies) throws Exception {
        ModelVersion version = model.getVersion();
        KernelServicesBuilder builder = this.createKernelServicesBuilder(AdditionalInitialization.MANAGEMENT);
        builder.createLegacyKernelServicesBuilder(null, controller, version).addMavenResourceURL(dependencies).dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List operations = builder.parseXmlResource("subsystem-jgroups-transform-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)version, (List)operations, (FailedOperationTransformationConfig)TransformersTestCase.createFailedOperationTransformationConfig(version));
    }

    private static FailedOperationTransformationConfig createFailedOperationTransformationConfig(ModelVersion version) {
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            config.addFailedAttribute(subsystemAddress, (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.NewAttributesConfig(new AttributeDefinition[]{JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL}));
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{ThreadPoolResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        if (JGroupsModel.VERSION_2_0_0.requiresTransformation(version)) {
            PathAddress stackAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH});
            PathAddress relayAddress = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
            config.addFailedAttribute(relayAddress, FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        return config;
    }
}

