/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TestInvocationHandler;

public abstract class AbstractPrimitivesTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractPrimitivesTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testBoolean() throws IOException {
        this.factory.createTester().test(true);
    }

    @Test
    public void testByte() throws IOException {
        for (int i = 0; i < 8; ++i) {
            if (i > 0) {
                this.factory.createTester().test(Integer.valueOf((1 << i) - 1).byteValue());
            }
            this.factory.createTester().test(Integer.valueOf(-1 << i).byteValue());
        }
    }

    @Test
    public void testShort() throws IOException {
        for (int i = 0; i < 16; ++i) {
            if (i > 0) {
                this.factory.createTester().test(Integer.valueOf((1 << i) - 1).shortValue());
            }
            this.factory.createTester().test(Integer.valueOf(-1 << i).shortValue());
        }
    }

    @Test
    public void testInteger() throws IOException {
        for (int i = 0; i < 32; ++i) {
            if (i > 0) {
                this.factory.createTester().test((1 << i) - 1);
            }
            this.factory.createTester().test(-1 << i);
        }
    }

    @Test
    public void testLong() throws IOException {
        for (int i = 0; i < 64; ++i) {
            if (i > 0) {
                this.factory.createTester().test((1L << i) - 1L);
            }
            this.factory.createTester().test(-1L << i);
        }
    }

    @Test
    public void testFloat() throws IOException {
        this.factory.createTester().test(Float.valueOf(Float.MIN_VALUE));
        this.factory.createTester().test(Float.valueOf(0.0f));
        this.factory.createTester().test(Float.valueOf(Float.MAX_VALUE));
    }

    @Test
    public void testDouble() throws IOException {
        this.factory.createTester().test((Double)Double.MIN_VALUE);
        this.factory.createTester().test(0.0);
        this.factory.createTester().test((Double)Double.MAX_VALUE);
    }

    @Test
    public void testCharacter() throws IOException {
        this.factory.createTester().test(Character.valueOf('\u0000'));
        this.factory.createTester().test(Character.valueOf('A'));
        this.factory.createTester().test(Character.valueOf('\uffff'));
    }

    @Test
    public void testString() throws IOException {
        this.factory.createTester().test("A");
        this.factory.createTester().test(UUID.randomUUID().toString());
    }

    @Test
    public void testBooleanArray() throws IOException {
        boolean[] array = new boolean[]{true, false};
        this.factory.createTester().test(array, Assert::assertArrayEquals);
        this.factory.createTester().test(new boolean[][]{array, array}, Assert::assertArrayEquals);
        Boolean[] objectArray = new Boolean[]{true, false};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Boolean[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testByteArray() throws IOException {
        byte[] array = new byte[]{-128, 0, 127};
        this.factory.createTester().test(array, Assert::assertArrayEquals);
        this.factory.createTester().test(new byte[][]{array, array}, Assert::assertArrayEquals);
        Byte[] objectArray = new Byte[]{(byte)-128, (byte)0, (byte)127};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Byte[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testShortArray() throws IOException {
        short[] array = new short[]{Short.MIN_VALUE, 0, Short.MAX_VALUE};
        this.factory.createTester().test(array, Assert::assertArrayEquals);
        this.factory.createTester().test(new short[][]{array, array}, Assert::assertArrayEquals);
        Short[] objectArray = new Short[]{(short)Short.MIN_VALUE, (short)0, (short)Short.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Short[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testIntegerArray() throws IOException {
        int[] array = new int[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createTester().test(array, Assert::assertArrayEquals);
        this.factory.createTester().test(new int[][]{array, array}, Assert::assertArrayEquals);
        Integer[] objectArray = new Integer[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Integer[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testLongArray() throws IOException {
        long[] array = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createTester().test(array, Assert::assertArrayEquals);
        this.factory.createTester().test(new long[][]{array, array}, Assert::assertArrayEquals);
        Long[] objectArray = new Long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Long[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testFloatArray() throws IOException {
        float[] array = new float[]{Float.MIN_VALUE, 0.0f, Float.MAX_VALUE};
        this.factory.createTester().test(array, AbstractPrimitivesTestCase::assertArrayEquals);
        this.factory.createTester().test(new float[][]{array, array}, Assert::assertArrayEquals);
        Float[] objectArray = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Float[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testDoubleArray() throws IOException {
        double[] array = new double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createTester().test(array, AbstractPrimitivesTestCase::assertArrayEquals);
        this.factory.createTester().test(new double[][]{array, array}, Assert::assertArrayEquals);
        Double[] objectArray = new Double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Double[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testCharArray() throws IOException {
        char[] array = new char[]{'\u0000', 'A', '\uffff'};
        this.factory.createTester().test(array, Assert::assertArrayEquals);
        this.factory.createTester().test(new char[][]{array, array}, Assert::assertArrayEquals);
        Character[] objectArray = new Character[]{Character.valueOf('\u0000'), Character.valueOf('A'), Character.valueOf('\uffff')};
        this.factory.createTester().test(objectArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new Character[][]{objectArray, objectArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testObjectArray() throws IOException {
        String string1 = "foo";
        String string2 = "bar";
        String[] stringArray = new String[]{string1, string2};
        this.factory.createTester().test(stringArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new String[]{string1, string1}, Assert::assertArrayEquals);
        this.factory.createTester().test(new String[][]{stringArray, stringArray}, Assert::assertArrayEquals);
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        UUID[] uuidArray = new UUID[]{uuid1, uuid2};
        this.factory.createTester().test(uuidArray, Assert::assertArrayEquals);
        this.factory.createTester().test(new UUID[]{uuid1, uuid1}, Assert::assertArrayEquals);
        this.factory.createTester().test(new UUID[][]{uuidArray, uuidArray}, Assert::assertArrayEquals);
        this.factory.createTester().test(new Object[]{uuid1, string1}, Assert::assertArrayEquals);
        this.factory.createTester().test(new Object[][]{stringArray, uuidArray}, Assert::assertArrayEquals);
    }

    @Test
    public void testNull() throws IOException {
        this.factory.createTester().test(null, Assert::assertSame);
    }

    @Test
    public void testClass() throws IOException {
        this.factory.createTester().test(Object.class, Assert::assertSame);
        this.factory.createTester().test(Exception.class, Assert::assertSame);
    }

    @Test
    public void testException() throws IOException {
        try {
            try {
                try {
                    throw new Error("foo");
                }
                catch (Throwable e) {
                    throw new RuntimeException("bar", e);
                }
            }
            catch (Throwable e) {
                throw new Exception(e);
            }
        }
        catch (Throwable e) {
            this.factory.createTester().test(e, AbstractPrimitivesTestCase::assertEquals);
            return;
        }
    }

    @Test
    public void testProxy() throws IOException {
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Iterable.class}, (InvocationHandler)new TestInvocationHandler(UUID.randomUUID()));
        this.factory.createTester().test(proxy, AbstractPrimitivesTestCase::assertProxyEquals);
    }

    private static void assertProxyEquals(Object expected, Object actual) {
        Assert.assertTrue((boolean)Proxy.isProxyClass(actual.getClass()));
        TestInvocationHandler actualHandler = (TestInvocationHandler)Proxy.getInvocationHandler(actual);
        TestInvocationHandler expectedHandler = (TestInvocationHandler)Proxy.getInvocationHandler(expected);
        Assert.assertEquals((Object)expectedHandler.getValue(), (Object)actualHandler.getValue());
    }

    private static void assertArrayEquals(float[] expected, float[] actual) {
        Assert.assertArrayEquals((float[])expected, (float[])actual, (float)0.0f);
    }

    private static void assertArrayEquals(double[] expected, double[] actual) {
        Assert.assertArrayEquals((double[])expected, (double[])actual, (double)0.0);
    }

    private static void assertEquals(Throwable expected, Throwable actual) {
        Assert.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        StackTraceElement[] expectedStackTrace = expected.getStackTrace();
        StackTraceElement[] actualStackTrace = expected.getStackTrace();
        Assert.assertEquals((long)expectedStackTrace.length, (long)actualStackTrace.length);
        for (int i = 0; i < expectedStackTrace.length; ++i) {
            StackTraceElement expectedElement = expectedStackTrace[i];
            StackTraceElement actualElement = actualStackTrace[i];
            Assert.assertEquals((Object)expectedElement.getClassName(), (Object)actualElement.getClassName());
            Assert.assertEquals((Object)expectedElement.getMethodName(), (Object)actualElement.getMethodName());
            Assert.assertEquals((Object)expectedElement.getFileName(), (Object)actualElement.getFileName());
            Assert.assertEquals((long)expectedElement.getLineNumber(), (long)actualElement.getLineNumber());
        }
        Throwable[] expectedSuppressed = expected.getSuppressed();
        Throwable[] actualSuppressed = actual.getSuppressed();
        Assert.assertEquals((long)expectedSuppressed.length, (long)actualSuppressed.length);
        for (int i = 0; i < expectedSuppressed.length; ++i) {
            AbstractPrimitivesTestCase.assertEquals(expectedSuppressed[i], actualSuppressed[i]);
        }
        Throwable cause1 = expected.getCause();
        Throwable cause2 = actual.getCause();
        if (cause1 != null && cause2 != null) {
            AbstractPrimitivesTestCase.assertEquals(cause1, cause2);
        } else {
            Assert.assertSame((Object)cause1, (Object)cause2);
        }
    }
}

