/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;

public abstract class AbstractTimeTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractTimeTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testDayOfWeek() throws IOException {
        this.factory.createTester(DayOfWeek.class).test();
    }

    @Test
    public void testDuration() throws IOException {
        MarshallingTester<Duration> tester = this.factory.createTester();
        tester.test(Duration.between(Instant.EPOCH, Instant.now()));
    }

    @Test
    public void testInstant() throws IOException {
        MarshallingTester<Instant> tester = this.factory.createTester();
        tester.test(Instant.now());
    }

    @Test
    public void testLocalDate() throws IOException {
        MarshallingTester<LocalDate> tester = this.factory.createTester();
        tester.test(LocalDate.now());
    }

    @Test
    public void testLocalDateTime() throws IOException {
        MarshallingTester<LocalDateTime> tester = this.factory.createTester();
        tester.test(LocalDateTime.now());
    }

    @Test
    public void testLocalTime() throws IOException {
        MarshallingTester<LocalTime> tester = this.factory.createTester();
        tester.test(LocalTime.now());
    }

    @Test
    public void testMonth() throws IOException {
        this.factory.createTester(Month.class).test();
    }

    @Test
    public void testMonthDay() throws IOException {
        MarshallingTester<MonthDay> tester = this.factory.createTester();
        tester.test(MonthDay.now());
    }

    @Test
    public void testOffsetDateTime() throws IOException {
        MarshallingTester<OffsetDateTime> tester = this.factory.createTester();
        tester.test(OffsetDateTime.now(ZoneOffset.UTC));
        tester.test(OffsetDateTime.now(ZoneOffset.MIN));
        tester.test(OffsetDateTime.now(ZoneOffset.MAX));
    }

    @Test
    public void testOffsetTime() throws IOException {
        MarshallingTester<OffsetTime> tester = this.factory.createTester();
        tester.test(OffsetTime.now(ZoneOffset.UTC));
        tester.test(OffsetTime.now(ZoneOffset.MIN));
        tester.test(OffsetTime.now(ZoneOffset.MAX));
    }

    @Test
    public void testZonedDateTime() throws IOException {
        MarshallingTester<ZonedDateTime> tester = this.factory.createTester();
        tester.test(ZonedDateTime.now(ZoneOffset.UTC));
        tester.test(ZonedDateTime.now(ZoneOffset.MIN));
        tester.test(ZonedDateTime.now(ZoneOffset.MAX));
    }

    @Test
    public void testPeriod() throws IOException {
        MarshallingTester<Period> tester = this.factory.createTester();
        tester.test(Period.between(LocalDate.ofEpochDay(0L), LocalDate.now()));
    }

    @Test
    public void testYear() throws IOException {
        MarshallingTester<Year> tester = this.factory.createTester();
        tester.test(Year.now());
    }

    @Test
    public void testYearMonth() throws IOException {
        MarshallingTester<YearMonth> tester = this.factory.createTester();
        tester.test(YearMonth.now());
    }

    @Test
    public void testZoneId() throws IOException {
        MarshallingTester<ZoneId> tester = this.factory.createTester();
        tester.test(ZoneId.of("America/New_York"));
    }

    @Test
    public void testZoneOffset() throws IOException {
        MarshallingTester<ZoneOffset> tester = this.factory.createTester();
        tester.test(ZoneOffset.UTC);
    }
}

