/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TestComparator;

public abstract class AbstractUtilTestCase {
    private static final Map<Object, Object> BASIS = Stream.of(1, 2, 3, 4, 5).collect(Collectors.toMap(i -> i, i -> Integer.toString(-i.intValue())));
    private final MarshallingTesterFactory factory;

    public AbstractUtilTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testArrayDeque() throws IOException {
        MarshallingTester<ArrayDeque> tester = this.factory.createTester();
        tester.test(new ArrayDeque<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testArrayList() throws IOException {
        MarshallingTester<ArrayList> tester = this.factory.createTester();
        tester.test(new ArrayList<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testBitSet() throws IOException {
        MarshallingTester<BitSet> tester = this.factory.createTester();
        tester.test(new BitSet(0));
        BitSet set = new BitSet(7);
        set.set(1);
        set.set(3);
        set.set(5);
        tester.test(set);
    }

    @Test
    public void testCalendar() throws IOException {
        MarshallingTester<Calendar> tester = this.factory.createTester();
        LocalDateTime time = LocalDateTime.now();
        tester.test(new Calendar.Builder().setDate(time.getYear(), time.getMonthValue(), time.getDayOfMonth()).build());
        tester.test(new Calendar.Builder().setLenient(false).setLocale(Locale.FRANCE).setDate(time.getYear(), time.getMonthValue(), time.getDayOfMonth()).setTimeOfDay(time.getHour(), time.getMinute(), time.getSecond()).build());
        tester.test(new Calendar.Builder().setLocale(Locale.JAPAN).setTimeZone(TimeZone.getTimeZone("Asia/Tokyo")).setInstant(Date.from(time.toInstant(ZoneOffset.UTC))).build());
        tester.test(new Calendar.Builder().setLocale(Locale.forLanguageTag("th_TH")).setTimeZone(TimeZone.getTimeZone("Asia/Bangkok")).build());
    }

    @Test
    public void testCurrency() throws IOException {
        MarshallingTester<Currency> tester = this.factory.createTester();
        tester.test(Currency.getInstance(Locale.getDefault()));
        tester.test(Currency.getInstance(Locale.UK));
    }

    @Test
    public void testDate() throws IOException {
        MarshallingTester<Date> tester = this.factory.createTester();
        tester.test(Date.from(Instant.EPOCH));
        tester.test(Date.from(Instant.now()));
    }

    @Test
    public void testEnumMap() throws IOException {
        MarshallingTester<EnumMap> tester = this.factory.createTester();
        EnumMap<Thread.State, String> map = new EnumMap<Thread.State, String>(Thread.State.class);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
        Iterator iterator = EnumSet.allOf(Thread.State.class).iterator();
        while (iterator.hasNext()) {
            Thread.State state;
            map.put(state, (state = (Thread.State)((Object)iterator.next())).ordinal() % 2 == 0 ? state.name() : null);
            tester.test(map, AbstractUtilTestCase::assertMapEquals);
        }
    }

    @Test
    public void testEnumSet() throws IOException {
        MarshallingTester<EnumSet> tester = this.factory.createTester();
        EnumSet<Thread.State> set = EnumSet.noneOf(Thread.State.class);
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        for (Thread.State state : EnumSet.allOf(Thread.State.class)) {
            set.add(state);
            tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        }
    }

    @Test
    public void testJumboEnumSet() throws IOException {
        MarshallingTester<EnumSet> tester = this.factory.createTester();
        tester.test(EnumSet.noneOf(Character.UnicodeScript.class), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.of(Character.UnicodeScript.UNKNOWN), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.of(Character.UnicodeScript.ARABIC, new Character.UnicodeScript[]{Character.UnicodeScript.ARMENIAN, Character.UnicodeScript.AVESTAN, Character.UnicodeScript.BALINESE, Character.UnicodeScript.BAMUM, Character.UnicodeScript.BATAK, Character.UnicodeScript.BENGALI, Character.UnicodeScript.BOPOMOFO, Character.UnicodeScript.BRAHMI, Character.UnicodeScript.BRAILLE, Character.UnicodeScript.BUGINESE, Character.UnicodeScript.BUHID, Character.UnicodeScript.CANADIAN_ABORIGINAL, Character.UnicodeScript.CARIAN}), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.complementOf(EnumSet.of(Character.UnicodeScript.UNKNOWN)), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(EnumSet.allOf(Character.UnicodeScript.class), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testHashMap() throws IOException {
        MarshallingTester<HashMap> tester = this.factory.createTester();
        tester.test(new HashMap<Object, Object>(BASIS), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testHashSet() throws IOException {
        MarshallingTester<HashSet> tester = this.factory.createTester();
        tester.test(new HashSet<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testLinkedHashMap() throws IOException {
        MarshallingTester<LinkedHashMap> tester = this.factory.createTester();
        tester.test(new LinkedHashMap<Object, Object>(BASIS), AbstractUtilTestCase::assertLinkedMapEquals);
        LinkedHashMap<Object, Object> accessOrderMap = new LinkedHashMap<Object, Object>(5, 1.0f, true);
        accessOrderMap.putAll(BASIS);
        tester.test(new LinkedHashMap(accessOrderMap), AbstractUtilTestCase::assertLinkedMapEquals);
    }

    @Test
    public void testLinkedHashSet() throws IOException {
        MarshallingTester<LinkedHashSet> tester = this.factory.createTester();
        tester.test(new LinkedHashSet<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testLinkedList() throws IOException {
        MarshallingTester<LinkedList> tester = this.factory.createTester();
        tester.test(new LinkedList<Object>(BASIS.keySet()), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testLocale() throws IOException {
        MarshallingTester<Locale> tester = this.factory.createTester();
        tester.test(Locale.getDefault());
        tester.test(Locale.ENGLISH);
        tester.test(Locale.CANADA_FRENCH);
    }

    @Test
    public void testOptional() throws IOException {
        MarshallingTester tester = this.factory.createTester();
        tester.test(Optional.empty());
        tester.test(Optional.of("foo"));
    }

    @Test
    public void testOptionalDouble() throws IOException {
        MarshallingTester<OptionalDouble> tester = this.factory.createTester();
        tester.test(OptionalDouble.empty());
        tester.test(OptionalDouble.of(Double.MAX_VALUE));
    }

    @Test
    public void testOptionalInt() throws IOException {
        MarshallingTester<OptionalInt> tester = this.factory.createTester();
        tester.test(OptionalInt.empty());
        tester.test(OptionalInt.of(Integer.MAX_VALUE));
    }

    @Test
    public void testOptionalLong() throws IOException {
        MarshallingTester<OptionalLong> tester = this.factory.createTester();
        tester.test(OptionalLong.empty());
        tester.test(OptionalLong.of(Long.MAX_VALUE));
    }

    @Test
    public void testSimpleEntry() throws IOException {
        MarshallingTester<AbstractMap.SimpleEntry<Object, Object>> tester = this.factory.createTester();
        String key = "key";
        String value = "value";
        tester.test(new AbstractMap.SimpleEntry<Object, Object>(null, null));
        tester.test(new AbstractMap.SimpleEntry<String, Object>(key, null));
        tester.test(new AbstractMap.SimpleEntry<String, String>(key, value));
        tester.test(new AbstractMap.SimpleEntry<String, String>(value, value));
    }

    @Test
    public void testSimpleImmutableEntry() throws IOException {
        MarshallingTester<AbstractMap.SimpleImmutableEntry<Object, Object>> tester = this.factory.createTester();
        String key = "key";
        String value = "value";
        tester.test(new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null));
        tester.test(new AbstractMap.SimpleImmutableEntry<String, Object>(key, null));
        tester.test(new AbstractMap.SimpleImmutableEntry<String, String>(key, value));
        tester.test(new AbstractMap.SimpleImmutableEntry<String, String>(value, value));
    }

    @Test
    public void testTimeZone() throws IOException {
        MarshallingTester<TimeZone> tester = this.factory.createTester();
        tester.test(TimeZone.getDefault());
        tester.test(TimeZone.getTimeZone("GMT"));
    }

    @Test
    public void testTreeMap() throws IOException {
        MarshallingTester<TreeMap> tester = this.factory.createTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
        map = new TreeMap(Comparator.reverseOrder());
        map.putAll(BASIS);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
        map = new TreeMap(new TestComparator());
        map.putAll(BASIS);
        tester.test(map, AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testTreeSet() throws IOException {
        MarshallingTester<TreeSet> tester = this.factory.createTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        set = new TreeSet(Comparator.reverseOrder());
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        set = new TreeSet(new TestComparator());
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testUUID() throws IOException {
        MarshallingTester<UUID> tester = this.factory.createTester();
        tester.test(UUID.randomUUID());
    }

    @Test
    public void testEmptyEnumeration() throws IOException {
        MarshallingTester<Enumeration> tester = this.factory.createTester();
        tester.test(Collections.emptyEnumeration(), Assert::assertSame);
    }

    @Test
    public void testEmptyIterator() throws IOException {
        MarshallingTester<Iterator> tester = this.factory.createTester();
        tester.test(Collections.emptyIterator(), Assert::assertSame);
    }

    @Test
    public void testEmptyList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.emptyList(), Assert::assertSame);
    }

    @Test
    public void testEmptyListIterator() throws IOException {
        MarshallingTester<ListIterator> tester = this.factory.createTester();
        tester.test(Collections.emptyListIterator(), Assert::assertSame);
    }

    @Test
    public void testEmptyMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        tester.test(Collections.emptyMap(), Assert::assertSame);
    }

    @Test
    public void testEmptyNavigableMap() throws IOException {
        MarshallingTester<NavigableMap> tester = this.factory.createTester();
        tester.test(Collections.emptyNavigableMap(), Assert::assertSame);
    }

    @Test
    public void testEmptyNavigableSet() throws IOException {
        MarshallingTester<NavigableSet> tester = this.factory.createTester();
        tester.test(Collections.emptyNavigableSet(), Assert::assertSame);
    }

    @Test
    public void testEmptySet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        tester.test(Collections.emptySet(), Assert::assertSame);
    }

    @Test
    public void testEmptySortedMap() throws IOException {
        MarshallingTester<SortedMap> tester = this.factory.createTester();
        tester.test(Collections.emptySortedMap(), Assert::assertSame);
    }

    @Test
    public void testEmptySortedSet() throws IOException {
        MarshallingTester<SortedSet> tester = this.factory.createTester();
        tester.test(Collections.emptySortedSet(), Assert::assertSame);
    }

    @Test
    public void testSingletonList() throws IOException {
        MarshallingTester<List> tester = this.factory.createTester();
        tester.test(Collections.singletonList(null), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Collections.singletonList("foo"), AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testSingletonMap() throws IOException {
        MarshallingTester<Map> tester = this.factory.createTester();
        tester.test(Collections.singletonMap(null, null), AbstractUtilTestCase::assertMapEquals);
        tester.test(Collections.singletonMap("foo", null), AbstractUtilTestCase::assertMapEquals);
        tester.test(Collections.singletonMap("foo", "bar"), AbstractUtilTestCase::assertMapEquals);
    }

    @Test
    public void testSingletonSet() throws IOException {
        MarshallingTester<Set> tester = this.factory.createTester();
        tester.test(Collections.singleton(null), AbstractUtilTestCase::assertCollectionEquals);
        tester.test(Collections.singleton("foo"), AbstractUtilTestCase::assertCollectionEquals);
    }

    static <T extends Collection<?>> void assertCollectionEquals(T expected, T actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertTrue((boolean)expected.containsAll(actual));
    }

    static <T extends Map<?, ?>> void assertMapEquals(T expected, T actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertTrue((String)actual.keySet().toString(), (boolean)expected.keySet().containsAll(actual.keySet()));
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            Assert.assertEquals(entry.getValue(), actual.get(entry.getKey()));
        }
    }

    static <T extends Map<?, ?>> void assertLinkedMapEquals(T expected, T actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        expected.get(expected.keySet().iterator().next());
        actual.get(actual.keySet().iterator().next());
        Iterator<Map.Entry<?, ?>> expectedEntries = expected.entrySet().iterator();
        Iterator<Map.Entry<?, ?>> actualEntries = actual.entrySet().iterator();
        while (expectedEntries.hasNext() && actualEntries.hasNext()) {
            Map.Entry<?, ?> expectedEntry = expectedEntries.next();
            Map.Entry<?, ?> actualEntry = actualEntries.next();
            Assert.assertEquals(expectedEntry.getKey(), actualEntry.getKey());
            Assert.assertEquals(expectedEntry.getValue(), actualEntry.getValue());
        }
    }
}

