/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.junit.Assert;
import org.wildfly.clustering.marshalling.SerializationTestMarshaller;
import org.wildfly.clustering.marshalling.TestMarshaller;
import org.wildfly.clustering.marshalling.Tester;

public class MarshallingTester<T>
implements Tester<T> {
    private final TestMarshaller<T> serializationMarshaller = new SerializationTestMarshaller();
    private final TestMarshaller<T> marshaller;

    public MarshallingTester(TestMarshaller<T> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public void test(T subject, BiConsumer<T, T> assertion) throws IOException {
        ByteBuffer buffer = this.marshaller.write(subject);
        int size = buffer.limit() - buffer.arrayOffset();
        if (subject != null) {
            // empty if block
        }
        T result = this.marshaller.read(buffer);
        assertion.accept(subject, result);
        if (subject instanceof Serializable) {
            ByteBuffer serializationBuffer = this.serializationMarshaller.write(subject);
            int serializationSize = serializationBuffer.limit() - serializationBuffer.arrayOffset();
            Assert.assertTrue((String)String.format("Marshaller size = %d, Default serialization size = %d", size, serializationSize), (size < serializationSize ? 1 : 0) != 0);
        }
    }
}

