/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.TestMarshaller;

public class ExternalizerMarshaller<T>
implements TestMarshaller<T> {
    private final Map<Class<?>, Externalizer<?>> externalizers;
    private Externalizer<T> currentExternalizer;

    ExternalizerMarshaller(Externalizer<T> externalizer) {
        this.externalizers = Collections.singletonMap(externalizer.getTargetClass(), externalizer);
    }

    ExternalizerMarshaller(Iterable<? extends Externalizer<?>> externalizers) {
        this.externalizers = new HashMap();
        for (Externalizer<?> externalizer : externalizers) {
            this.externalizers.put(externalizer.getTargetClass(), externalizer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(ByteBuffer buffer) throws IOException {
        try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(buffer.array(), buffer.arrayOffset(), buffer.limit() - buffer.arrayOffset()));){
            Object object = this.currentExternalizer.readObject((ObjectInput)input);
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ByteBuffer write(T object) throws IOException {
        Class<Object> targetClass = object.getClass().isEnum() ? ((Enum)object).getDeclaringClass() : object.getClass();
        Class<Object> superClass = targetClass.getSuperclass();
        while (!this.externalizers.containsKey(targetClass) && superClass != null && Modifier.isAbstract(superClass.getModifiers())) {
            targetClass = superClass;
            superClass = targetClass.getSuperclass();
        }
        this.currentExternalizer = this.externalizers.get(targetClass);
        ByteArrayOutputStream externalizedOutput = new ByteArrayOutputStream();
        try (ObjectOutputStream output = new ObjectOutputStream(externalizedOutput);){
            this.currentExternalizer.writeObject((ObjectOutput)output, object);
        }
        return ByteBuffer.wrap(externalizedOutput.toByteArray());
    }
}

