/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValue;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class SimpleMarshalledValueExternalizer<T>
implements Externalizer<SimpleMarshalledValue<T>> {
    static ByteBuffer readBuffer(ObjectInput input) throws IOException {
        byte[] bytes;
        int size = IndexSerializer.VARIABLE.readInt((DataInput)input);
        byte[] byArray = bytes = size > 0 ? new byte[size] : null;
        if (bytes != null) {
            input.readFully(bytes);
        }
        return bytes != null ? ByteBuffer.wrap(bytes) : null;
    }

    static void writeBuffer(ObjectOutput output, ByteBuffer buffer) throws IOException {
        int length = buffer != null ? buffer.limit() - buffer.arrayOffset() : 0;
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, length);
        if (length > 0) {
            output.write(buffer.array(), buffer.arrayOffset(), length);
        }
    }

    public SimpleMarshalledValue<T> readObject(ObjectInput input) throws IOException {
        return new SimpleMarshalledValue(SimpleMarshalledValueExternalizer.readBuffer(input));
    }

    public void writeObject(ObjectOutput output, SimpleMarshalledValue<T> object) throws IOException {
        SimpleMarshalledValueExternalizer.writeBuffer(output, object.getBuffer());
    }

    public Class<SimpleMarshalledValue<T>> getTargetClass() {
        return SimpleMarshalledValue.class;
    }
}

