/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.junit.Assert;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TestMarshaller;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferTestMarshaller;

public class JBossMarshallingTesterFactory
implements MarshallingTesterFactory,
MarshallingConfigurationRepository {
    private final MarshallingConfiguration configuration = new MarshallingConfiguration();
    private final ClassLoader loader;

    public JBossMarshallingTesterFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public JBossMarshallingTesterFactory(ClassLoader loader) {
        this.loader = loader;
        this.configuration.setClassTable((ClassTable)new DynamicClassTable(new ClassLoader[]{loader}));
        this.configuration.setObjectTable((ObjectTable)new ExternalizerObjectTable(new ClassLoader[]{loader}));
    }

    public <T> MarshallingTester<T> createTester() {
        return new MarshallingTester((TestMarshaller)new ByteBufferTestMarshaller((ByteBufferMarshaller)new JBossByteBufferMarshaller((MarshallingConfigurationRepository)this, this.loader)));
    }

    public int getCurrentMarshallingVersion() {
        return 0;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        Assert.assertEquals((long)this.getCurrentMarshallingVersion(), (long)version);
        return this.configuration;
    }
}

