/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContextInitializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SerializationContextBuilder {
    private final SerializationContext context = new SerializationContextImpl(Configuration.builder().build());

    public SerializationContextBuilder() {
        this.register(EnumSet.allOf(DefaultSerializationContextInitializer.class));
    }

    public ImmutableSerializationContext build() {
        return this.context;
    }

    public SerializationContextBuilder register(SerializationContextInitializer initializer) {
        this.init(initializer);
        return this;
    }

    public SerializationContextBuilder register(SerializationContextInitializer ... initializers) {
        return this.register(Arrays.asList(initializers));
    }

    public SerializationContextBuilder register(Iterable<? extends SerializationContextInitializer> initializers) {
        this.init(initializers);
        return this;
    }

    public SerializationContextBuilder register(final ClassLoader ... loaders) throws NoSuchElementException {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean init = false;
                for (ClassLoader loader : loaders) {
                    init |= SerializationContextBuilder.this.init(ServiceLoader.load(SerializationContextInitializer.class, loader));
                }
                return init;
            }
        };
        if (!((Boolean)WildFlySecurityManager.doUnchecked((PrivilegedAction)action)).booleanValue()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    boolean init(Iterable<? extends SerializationContextInitializer> initializers) {
        Iterator<? extends SerializationContextInitializer> iter = initializers.iterator();
        boolean result = iter.hasNext();
        while (iter.hasNext()) {
            this.init(iter.next());
        }
        return result;
    }

    private void init(SerializationContextInitializer initializer) {
        initializer.registerSchema(this.context);
        initializer.registerMarshallers(this.context);
    }
}

