/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamDataInput;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamDataOutput;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.common.function.ExceptionToIntFunction;

public class ProtoStreamDataStreamTestCase {
    @Test
    public void testByte() throws IOException {
        ProtoStreamDataStreamTestCase.test(8, true, (ExceptionObjIntConsumer<DataOutput, IOException>)((ExceptionObjIntConsumer)DataOutput::writeByte), (ExceptionToIntFunction<DataInput, IOException>)((ExceptionToIntFunction)DataInput::readByte));
    }

    @Test
    public void testUnsignedByte() throws IOException {
        ProtoStreamDataStreamTestCase.test(8, false, (ExceptionObjIntConsumer<DataOutput, IOException>)((ExceptionObjIntConsumer)DataOutput::writeByte), (ExceptionToIntFunction<DataInput, IOException>)((ExceptionToIntFunction)DataInput::readUnsignedByte));
    }

    @Test
    public void testShort() throws IOException {
        ProtoStreamDataStreamTestCase.test(16, true, (ExceptionObjIntConsumer<DataOutput, IOException>)((ExceptionObjIntConsumer)DataOutput::writeShort), (ExceptionToIntFunction<DataInput, IOException>)((ExceptionToIntFunction)DataInput::readShort));
    }

    @Test
    public void testUnsignedShort() throws IOException {
        ProtoStreamDataStreamTestCase.test(16, false, (ExceptionObjIntConsumer<DataOutput, IOException>)((ExceptionObjIntConsumer)DataOutput::writeShort), (ExceptionToIntFunction<DataInput, IOException>)((ExceptionToIntFunction)DataInput::readUnsignedShort));
    }

    @Test
    public void testInt() throws IOException {
        ProtoStreamDataStreamTestCase.test(32, true, (ExceptionObjIntConsumer<DataOutput, IOException>)((ExceptionObjIntConsumer)DataOutput::writeInt), (ExceptionToIntFunction<DataInput, IOException>)((ExceptionToIntFunction)DataInput::readInt));
    }

    private static void test(int bits, boolean signed, ExceptionObjIntConsumer<DataOutput, IOException> write, ExceptionToIntFunction<DataInput, IOException> read) throws IOException {
        for (int i = 0; i <= bits - (signed ? 1 : 0); ++i) {
            ProtoStreamDataStreamTestCase.testInt((1 << i) - 1, write, read);
            if (!signed) continue;
            ProtoStreamDataStreamTestCase.testInt(-1 << i, write, read);
        }
    }

    private static void testInt(int i, ExceptionObjIntConsumer<DataOutput, IOException> write, ExceptionToIntFunction<DataInput, IOException> read) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(32);
        RawProtoStreamWriter writer = RawProtoStreamWriterImpl.newInstance((OutputStream)bytes);
        ProtoStreamDataOutput output = new ProtoStreamDataOutput(null, writer);
        write.accept((Object)output, i);
        writer.flush();
        ProtoStreamDataInput input = new ProtoStreamDataInput(null, RawProtoStreamReaderImpl.newInstance((InputStream)new ByteArrayInputStream(bytes.toByteArray())));
        Assert.assertEquals((long)i, (long)read.apply((Object)input));
    }

    @Test
    public void testByteArray() throws IOException {
        UUID id = UUID.randomUUID();
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(id.getMostSignificantBits());
        buffer.putLong(id.getLeastSignificantBits());
        byte[] source = buffer.array();
        byte[] test = new byte[source.length + 2];
        System.arraycopy(source, 0, test, 1, source.length);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        RawProtoStreamWriter writer = RawProtoStreamWriterImpl.newInstance((OutputStream)bytes);
        ProtoStreamDataOutput output = new ProtoStreamDataOutput(null, writer);
        output.write(test, 1, source.length);
        writer.flush();
        ProtoStreamDataInput input = new ProtoStreamDataInput(null, RawProtoStreamReaderImpl.newInstance((InputStream)new ByteArrayInputStream(bytes.toByteArray())));
        byte[] result = new byte[source.length];
        input.readFully(result);
        Assert.assertArrayEquals((byte[])source, (byte[])result);
    }
}

