/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;

public interface ProtoStreamWriter
extends ProtoStreamOperation,
TagWriter {
    default public void writeObject(int index, Object value) throws IOException {
        this.writeTag(index, WireType.LENGTH_DELIMITED);
        this.writeObjectNoTag(value);
    }

    public void writeObjectNoTag(Object var1) throws IOException;

    default public <E extends Enum<E>> void writeEnum(int index, E value) throws IOException {
        EnumMarshaller marshaller = (EnumMarshaller)this.getSerializationContext().getMarshaller(value.getDeclaringClass());
        this.writeEnum(index, marshaller.encode(value));
    }

    default public <T, V extends T> ProtobufTagMarshaller<T> findMarshaller(Class<V> javaClass) {
        ImmutableSerializationContext context = this.getSerializationContext();
        IllegalArgumentException exception = null;
        for (Class<V> targetClass = javaClass; targetClass != null; targetClass = targetClass.getSuperclass()) {
            try {
                return (ProtobufTagMarshaller)context.getMarshaller(targetClass);
            }
            catch (IllegalArgumentException e) {
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    @Deprecated
    public void writeTag(int var1, int var2) throws IOException;

    @Deprecated
    public void writeInt32(int var1, int var2) throws IOException;

    @Deprecated
    public void writeInt64(int var1, long var2) throws IOException;

    @Deprecated
    public void writeFixed32(int var1, int var2) throws IOException;

    @Deprecated
    public void writeFixed64(int var1, long var2) throws IOException;
}

