/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.io.IOException;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartException;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;

public class ExceptionTestCase {
    @Test
    public void test() throws IOException {
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        tester.test((Object)new StartException(), ExceptionTestCase::assertEquals);
        tester.test((Object)new StartException("message"), ExceptionTestCase::assertEquals);
        tester.test((Object)new StartException((Throwable)new Exception()), ExceptionTestCase::assertEquals);
        tester.test((Object)new StartException("message", (Throwable)new Exception()), ExceptionTestCase::assertEquals);
        tester.test((Object)new ServiceNotFoundException(), ExceptionTestCase::assertEquals);
        tester.test((Object)new ServiceNotFoundException("message"), ExceptionTestCase::assertEquals);
        tester.test((Object)new ServiceNotFoundException((Throwable)new Exception()), ExceptionTestCase::assertEquals);
        tester.test((Object)new ServiceNotFoundException("message", (Throwable)new Exception()), ExceptionTestCase::assertEquals);
    }

    private static void assertEquals(Throwable exception1, Throwable exception2) {
        if (exception1 != null && exception2 != null) {
            Assert.assertSame(exception1.getClass(), exception2.getClass());
            Assert.assertEquals((Object)exception1.getMessage(), (Object)exception2.getMessage());
            ExceptionTestCase.assertEquals(exception1.getCause(), exception2.getCause());
        } else {
            Assert.assertSame((Object)exception1, (Object)exception2);
        }
    }
}

