/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.wildfly.clustering.singleton.election.SingletonElectionListener;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.server.SingletonServiceBuilderContext;
import org.wildfly.clustering.singleton.service.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.service.SingletonServiceController;

public abstract class AbstractSingletonServiceBuilder<T>
extends DelegatingServiceBuilder<T>
implements SingletonServiceBuilder<T> {
    private final SingletonServiceBuilderContext context;

    public AbstractSingletonServiceBuilder(ServiceBuilder<T> builder, SingletonServiceBuilderContext context) {
        super(builder);
        context.getCommandDispatcherFactoryDependency().accept(builder);
        context.getServiceProviderRegistrarDependency().accept(builder);
        this.context = context;
    }

    public abstract SingletonServiceBuilder<T> setInstance(Service var1);

    public abstract SingletonServiceController<T> install();

    public SingletonServiceBuilder<T> requireQuorum(int quorum) {
        this.context.setQuorum(quorum);
        return this;
    }

    public SingletonServiceBuilder<T> withElectionPolicy(SingletonElectionPolicy policy) {
        this.context.setElectionPolicy(policy);
        return this;
    }

    public SingletonServiceBuilder<T> withElectionListener(SingletonElectionListener listener) {
        this.context.setElectionListener(listener);
        return this;
    }

    public SingletonServiceBuilder<T> addListener(LifecycleListener listener) {
        this.getDelegate().addListener(listener);
        return this;
    }

    public SingletonServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.getDelegate().setInitialMode(mode);
        return this;
    }
}

