/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.server;

import java.util.List;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jgroups.Address;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupMember;
import org.wildfly.clustering.singleton.server.PrimaryProviderCommand;
import org.wildfly.clustering.singleton.server.SingletonElectionCommand;
import org.wildfly.clustering.singleton.server.SingletonValueCommand;
import org.wildfly.clustering.singleton.server.StartCommand;
import org.wildfly.clustering.singleton.server.StopCommand;

public class CommandMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(TesterFactory factory) {
        factory.createTester().accept((Object)StartCommand.INSTANCE);
        factory.createTester().accept((Object)StopCommand.INSTANCE);
        factory.createTester().accept((Object)PrimaryProviderCommand.INSTANCE);
        factory.createTester(Assertions::assertSame).accept((Object)SingletonValueCommand.INSTANCE);
        CacheContainerGroupMember elected = CommandMarshallerTestCase.createMember();
        factory.createTester(CommandMarshallerTestCase::assertEquals).accept((Object)new SingletonElectionCommand(List.of(CommandMarshallerTestCase.createMember(), elected, CommandMarshallerTestCase.createMember()), (GroupMember)elected));
    }

    private static CacheContainerGroupMember createMember() {
        return new EmbeddedCacheManagerGroupMember(new JGroupsAddress((Address)UUID.randomUUID()));
    }

    private static void assertEquals(SingletonElectionCommand command1, SingletonElectionCommand command2) {
        Assertions.assertEquals((Object)command1.getCandidates(), (Object)command2.getCandidates());
        Assertions.assertEquals((Integer)command1.getIndex(), (Integer)command2.getIndex());
    }
}

