/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.singleton;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.ResponseFilter;
import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.msc.DelegatingServiceBuilder;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.clustering.msc.ServiceControllerFactory;
import org.jboss.as.clustering.service.ServiceProviderRegistry;
import org.jboss.as.clustering.service.ServiceProviderRegistryService;
import org.jboss.as.clustering.singleton.Singleton;
import org.jboss.as.clustering.singleton.SingletonElectionPolicy;
import org.jboss.as.clustering.singleton.SingletonLogger;
import org.jboss.as.clustering.singleton.SingletonMessages;
import org.jboss.as.clustering.singleton.SingletonRpcHandler;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SingletonService<T extends Serializable>
implements Service<T>,
ServiceProviderRegistry.Listener,
SingletonRpcHandler<T>,
Singleton {
    public static final String DEFAULT_CONTAINER = "singleton";
    private final InjectedValue<ServiceProviderRegistry> registryRef = new InjectedValue();
    private final InjectedValue<GroupRpcDispatcher> dispatcherRef = new InjectedValue();
    private final Service<T> service;
    private final ServiceName targetServiceName;
    private final ServiceName singletonServiceName;
    private final AtomicBoolean master = new AtomicBoolean(false);
    volatile ServiceProviderRegistry registry;
    volatile GroupRpcDispatcher dispatcher;
    volatile boolean started = false;
    private volatile SingletonElectionPolicy electionPolicy;
    private volatile SingletonRpcHandler<T> handler;
    private volatile ServiceRegistry container;
    private volatile boolean restartOnMerge = true;
    final int quorum;

    public SingletonService(Service<T> service, ServiceName serviceName) {
        this(service, serviceName, 1);
    }

    public SingletonService(Service<T> service, ServiceName serviceName, int quorum) {
        this.service = service;
        this.targetServiceName = serviceName.append(new String[]{"service"});
        this.singletonServiceName = serviceName;
        this.quorum = quorum;
    }

    public ServiceBuilder<T> build(ServiceTarget target) {
        return this.build(target, DEFAULT_CONTAINER);
    }

    public ServiceBuilder<T> build(ServiceTarget target, String container) {
        ServiceBuilder serviceBuilder = target.addService(this.targetServiceName, this.service).setInitialMode(ServiceController.Mode.NEVER);
        AbstractServiceListener listener = new AbstractServiceListener<T>(){

            public void serviceRemoveRequested(ServiceController<? extends T> controller) {
                ServiceController service = controller.getServiceContainer().getService(SingletonService.this.targetServiceName);
                if (service != null) {
                    service.setMode(ServiceController.Mode.REMOVE);
                }
            }
        };
        final ServiceBuilder singletonBuilder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)this.singletonServiceName, (Service)this).addAliases(new ServiceName[]{this.singletonServiceName.append(new String[]{DEFAULT_CONTAINER})}).addDependency(ServiceProviderRegistryService.getServiceName((String)container), ServiceProviderRegistry.class, this.registryRef).addDependency(CoreGroupCommunicationService.getServiceName((String)container), GroupRpcDispatcher.class, this.dispatcherRef).addListener((ServiceListener)listener);
        return new DelegatingServiceBuilder<T>(serviceBuilder, ServiceControllerFactory.SIMPLE){

            public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
                singletonBuilder.addAliases(aliases);
                return this;
            }

            public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
                singletonBuilder.setInitialMode(mode);
                return this;
            }

            public ServiceController<T> install() {
                super.install();
                return singletonBuilder.install();
            }
        };
    }

    public void start(StartContext context) {
        this.container = context.getController().getServiceContainer();
        this.dispatcher = (GroupRpcDispatcher)this.dispatcherRef.getValue();
        this.registry = (ServiceProviderRegistry)this.registryRef.getValue();
        String name = this.singletonServiceName.getCanonicalName();
        this.handler = new RpcHandler(name);
        this.dispatcher.registerRPCHandler(name, (Object)this);
        this.registry.register(name, (ServiceProviderRegistry.Listener)this);
        this.started = true;
    }

    public void stop(StopContext context) {
        this.started = false;
        String name = this.singletonServiceName.getCanonicalName();
        this.registry.unregister(name);
        this.dispatcher.unregisterRPCHandler(name, (Object)this);
    }

    @Override
    public boolean isMaster() {
        return this.master.get();
    }

    public void setElectionPolicy(SingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
    }

    public void setRestartOnMerge(boolean restart) {
        this.restartOnMerge = restart;
    }

    public void serviceProvidersChanged(Set<ClusterNode> nodes, boolean merge) {
        if (this.elected(nodes)) {
            if (this.master.get()) {
                if (this.restartOnMerge && merge) {
                    this.stopOldMaster();
                    this.startNewMaster();
                }
            } else {
                SingletonLogger.ROOT_LOGGER.electedMaster(this.singletonServiceName.getCanonicalName());
                this.handler.stopOldMaster();
                this.startNewMaster();
            }
        } else if (this.master.get()) {
            SingletonLogger.ROOT_LOGGER.electedSlave(this.singletonServiceName.getCanonicalName());
            this.stopOldMaster();
        }
    }

    private boolean elected(Set<ClusterNode> candidates) {
        ClusterNode elected;
        int size = candidates.size();
        if (size < this.quorum) {
            SingletonLogger.ROOT_LOGGER.quorumNotReached(this.singletonServiceName.getCanonicalName(), this.quorum);
            return false;
        }
        if (size == this.quorum) {
            SingletonLogger.ROOT_LOGGER.quorumJustReached(this.singletonServiceName.getCanonicalName(), this.quorum);
        }
        if ((elected = this.election(candidates)) != null) {
            SingletonLogger.ROOT_LOGGER.elected(elected.getName(), this.singletonServiceName.getCanonicalName());
        }
        return elected != null ? elected.equals(this.dispatcher.getClusterNode()) : false;
    }

    private ClusterNode election(Set<ClusterNode> candidates) {
        List nodes = this.dispatcher.getClusterNodes();
        nodes.retainAll(candidates);
        if (nodes.isEmpty()) {
            return null;
        }
        return this.electionPolicy == null ? (ClusterNode)nodes.get(0) : this.electionPolicy.elect(nodes);
    }

    private void startNewMaster() {
        this.master.set(true);
        ServiceController service = this.container.getRequiredService(this.targetServiceName);
        try {
            ServiceContainerHelper.start((ServiceController)service);
        }
        catch (StartException e) {
            SingletonLogger.ROOT_LOGGER.serviceStartFailed(e, this.targetServiceName.getCanonicalName());
            ServiceContainerHelper.stop((ServiceController)service);
        }
    }

    public T getValue() {
        if (!this.started) {
            throw new IllegalStateException();
        }
        AtomicReference<T> ref = this.getValueRef();
        if (ref == null) {
            ref = this.handler.getValueRef();
        }
        return (T)((Serializable)ref.get());
    }

    @Override
    public AtomicReference<T> getValueRef() {
        return this.master.get() ? new AtomicReference<Object>(this.service.getValue()) : null;
    }

    @Override
    public void stopOldMaster() {
        if (this.master.compareAndSet(true, false)) {
            ServiceContainerHelper.stop((ServiceController)this.container.getRequiredService(this.targetServiceName));
        }
    }

    private class RpcHandler
    implements SingletonRpcHandler<T>,
    ResponseFilter {
        private final String name;

        RpcHandler(String name) {
            this.name = name;
        }

        @Override
        public void stopOldMaster() {
            try {
                SingletonService.this.dispatcher.callMethodOnCluster(this.name, "stopOldMaster", new Object[0], new Class[0], true);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public AtomicReference<T> getValueRef() {
            try {
                List results = Collections.emptyList();
                while (results.isEmpty()) {
                    if (!SingletonService.this.started) {
                        throw new IllegalStateException(SingletonMessages.MESSAGES.notStarted(this.name));
                    }
                    results = SingletonService.this.dispatcher.callMethodOnCluster(this.name, "getValueRef", new Object[0], new Class[0], false, (ResponseFilter)this);
                    Iterator refs = results.iterator();
                    while (refs.hasNext()) {
                        if (refs.next() != null) continue;
                        refs.remove();
                    }
                    int count = results.size();
                    if (count > 1) {
                        throw SingletonMessages.MESSAGES.unexpectedResponseCount(this.name, count);
                    }
                    if (count != 0) continue;
                    SingletonLogger.ROOT_LOGGER.noResponseFromMaster(this.name);
                    if (SingletonService.this.registry.getServiceProviders(this.name).size() < SingletonService.this.quorum) {
                        return new AtomicReference();
                    }
                    Thread.yield();
                }
                return (AtomicReference)results.get(0);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean isAcceptable(Object response, ClusterNode sender) {
            return response == null || !(response instanceof IllegalStateException);
        }

        public boolean needMoreResponses() {
            return true;
        }
    }
}

