/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.EnumSet;
import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.infinispan.client.service.InfinispanClientRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanDefaultCacheRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanRequirement;
import org.wildfly.extension.clustering.web.DistributableWebExtension;
import org.wildfly.extension.clustering.web.DistributableWebModel;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementResourceDefinition;

@RunWith(value=Parameterized.class)
public class DistributableWebTransformerTestCase
extends AbstractSubsystemTest {
    private final ModelTestControllerVersion controller;
    private final AdditionalInitialization additionalInitialization;
    private final ModelVersion version;

    @Parameterized.Parameters
    public static Iterable<ModelTestControllerVersion> parameters() {
        return EnumSet.of(ModelTestControllerVersion.EAP_7_4_0);
    }

    public DistributableWebTransformerTestCase(ModelTestControllerVersion controller) {
        super("distributable-web", (Extension)new DistributableWebExtension());
        this.controller = controller;
        this.version = this.getModelVersion().getVersion();
        this.additionalInitialization = new org.jboss.as.clustering.subsystem.AdditionalInitialization().require(InfinispanRequirement.CONTAINER.resolve("foo")).require(InfinispanDefaultCacheRequirement.CACHE.resolve("foo")).require(InfinispanDefaultCacheRequirement.CONFIGURATION.resolve("foo")).require(InfinispanCacheRequirement.CACHE.resolve("foo", "bar")).require(InfinispanCacheRequirement.CONFIGURATION.resolve("foo", "bar")).require(InfinispanClientRequirement.REMOTE_CONTAINER.resolve("foo")).require(InfinispanCacheRequirement.CACHE.resolve("foo", "routing")).require(InfinispanCacheRequirement.CONFIGURATION.resolve("foo", "routing"));
    }

    private String formatSubsystemArtifact() {
        return this.formatArtifact("org.jboss.eap:wildfly-clustering-web-extension:%s");
    }

    private String formatArtifact(String pattern) {
        return String.format(pattern, this.controller.getMavenGavVersion());
    }

    private DistributableWebModel getModelVersion() {
        switch (this.controller) {
            case EAP_7_4_0: {
                return DistributableWebModel.VERSION_2_0_0;
            }
        }
        throw new IllegalArgumentException();
    }

    private String[] getDependencies() {
        switch (this.controller) {
            case EAP_7_4_0: {
                return new String[]{this.formatSubsystemArtifact(), this.formatArtifact("org.jboss.eap:wildfly-clustering-common:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-ee-hotrod:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-ee-infinispan:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-ee-spi:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-infinispan-client:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-infinispan-spi:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-marshalling-spi:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-service:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-web-container:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-web-hotrod:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-web-infinispan:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-web-spi:%s")};
            }
        }
        throw new IllegalArgumentException();
    }

    @Test
    public void testTransformation() throws Exception {
        String subsystemXmlResource = String.format("wildfly-distributable-web-transform-%d_%d_%d.xml", this.version.getMajor(), this.version.getMinor(), this.version.getMicro());
        KernelServicesBuilder builder = this.createKernelServicesBuilder(this.additionalInitialization).setSubsystemXmlResource(subsystemXmlResource);
        builder.createLegacyKernelServicesBuilder(this.additionalInitialization, this.controller, this.version).addMavenResourceURL(this.getDependencies()).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).skipReverseControllerCheck().dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)((KernelServices)services.getLegacyServices(this.version)).isSuccessfulBoot());
        this.checkSubsystemModelTransformation(services, this.version, null, false);
    }

    @Test
    public void testRejections() throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder(this.additionalInitialization);
        builder.createLegacyKernelServicesBuilder(this.additionalInitialization, this.controller, this.version).addMavenResourceURL(this.getDependencies()).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(this.version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List operations = builder.parseXmlResource("wildfly-distributable-web-transform-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)this.version, (List)operations, (FailedOperationTransformationConfig)this.createFailedOperationTransformationConfig());
    }

    private FailedOperationTransformationConfig createFailedOperationTransformationConfig() {
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((String)"subsystem", (String)"distributable-web");
        if (DistributableWebModel.VERSION_3_0_0.requiresTransformation(this.version)) {
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{InfinispanSessionManagementResourceDefinition.pathElement((String)"protostream")}), (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.NewAttributesConfig(new String[]{SessionManagementResourceDefinition.Attribute.MARSHALLER.getName()}));
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{HotRodSessionManagementResourceDefinition.pathElement((String)"remote-protostream")}), (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.NewAttributesConfig(new String[]{SessionManagementResourceDefinition.Attribute.MARSHALLER.getName()}));
        }
        return config;
    }
}

