/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.controller.Schema;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.web.infinispan.routing.RankedRoutingConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentSchema;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentXMLReader;
import org.wildfly.extension.clustering.web.deployment.MutableDistributableDeploymentConfiguration;
import org.wildfly.extension.clustering.web.routing.NullRouteLocatorServiceConfiguratorFactory;
import org.wildfly.extension.clustering.web.routing.infinispan.RankedRouteLocatorServiceConfiguratorFactory;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementProvider;
import org.wildfly.extension.clustering.web.session.infinispan.InfinispanSessionManagementProvider;

@RunWith(value=Parameterized.class)
public class DistributableWebDeploymentXMLReaderTestCase {
    private final DistributableWebDeploymentSchema schema;

    @Parameterized.Parameters
    public static Iterable<DistributableWebDeploymentSchema> parameters() {
        return EnumSet.allOf(DistributableWebDeploymentSchema.class);
    }

    public DistributableWebDeploymentXMLReaderTestCase(DistributableWebDeploymentSchema schema) {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws IOException, XMLStreamException {
        URL url = this.getClass().getResource(String.format("distributable-web-%d.%d.xml", this.schema.major(), this.schema.minor()));
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.schema.getRoot(), (XMLElementReader)new DistributableWebDeploymentXMLReader(this.schema));
        try (InputStream input = url.openStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            MutableDistributableDeploymentConfiguration config = new MutableDistributableDeploymentConfiguration();
            mapper.parseDocument((Object)config, reader);
            Assert.assertNull((Object)config.getSessionManagement());
            Assert.assertEquals((Object)"foo", (Object)config.getSessionManagementName());
            Assert.assertNotNull((Object)config.getImmutableClasses());
            Assert.assertEquals(Arrays.asList(Locale.class.getName(), UUID.class.getName()), (Object)config.getImmutableClasses());
        }
        finally {
            mapper.unregisterRootAttribute(this.schema.getRoot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInfinispan() throws IOException, XMLStreamException {
        URL url = this.getClass().getResource(String.format("distributable-web-infinispan-%d.%d.xml", this.schema.major(), this.schema.minor()));
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.schema.getRoot(), (XMLElementReader)new DistributableWebDeploymentXMLReader(this.schema));
        try (InputStream input = url.openStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            MutableDistributableDeploymentConfiguration config = new MutableDistributableDeploymentConfiguration();
            mapper.parseDocument((Object)config, reader);
            Assert.assertNull((Object)config.getSessionManagementName());
            DistributableSessionManagementProvider result = config.getSessionManagement();
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof InfinispanSessionManagementProvider));
            InfinispanSessionManagementProvider provider = (InfinispanSessionManagementProvider)result;
            InfinispanSessionManagementConfiguration configuration = provider.getSessionManagementConfiguration();
            Assert.assertEquals((Object)"foo", (Object)configuration.getContainerName());
            Assert.assertEquals((Object)"bar", (Object)configuration.getCacheName());
            Assert.assertSame((Object)SessionAttributePersistenceStrategy.FINE, (Object)configuration.getAttributePersistenceStrategy());
            if (this.schema.since((Schema)DistributableWebDeploymentSchema.VERSION_2_0)) {
                Assert.assertTrue((boolean)(provider.getRouteLocatorServiceConfiguratorFactory() instanceof RankedRouteLocatorServiceConfiguratorFactory));
                RankedRoutingConfiguration routing = ((RankedRouteLocatorServiceConfiguratorFactory)provider.getRouteLocatorServiceConfiguratorFactory()).getConfiguration();
                Assert.assertEquals((Object)":", (Object)routing.getDelimiter());
                Assert.assertEquals((long)4L, (long)routing.getMaxRoutes());
            } else {
                Assert.assertTrue((boolean)(provider.getRouteLocatorServiceConfiguratorFactory() instanceof NullRouteLocatorServiceConfiguratorFactory));
            }
            Assert.assertNotNull((Object)config.getImmutableClasses());
            Assert.assertEquals(Arrays.asList(Locale.class.getName(), UUID.class.getName()), (Object)config.getImmutableClasses());
        }
        finally {
            mapper.unregisterRootAttribute(this.schema.getRoot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHotRod() throws IOException, XMLStreamException {
        URL url = this.getClass().getResource(String.format("distributable-web-hotrod-%d.%d.xml", this.schema.major(), this.schema.minor()));
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.schema.getRoot(), (XMLElementReader)new DistributableWebDeploymentXMLReader(this.schema));
        try (InputStream input = url.openStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            MutableDistributableDeploymentConfiguration config = new MutableDistributableDeploymentConfiguration();
            mapper.parseDocument((Object)config, reader);
            Assert.assertNull((Object)config.getSessionManagementName());
            DistributableSessionManagementProvider result = config.getSessionManagement();
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof HotRodSessionManagementProvider));
            HotRodSessionManagementConfiguration configuration = ((HotRodSessionManagementProvider)result).getSessionManagementConfiguration();
            Assert.assertEquals((Object)"foo", (Object)configuration.getContainerName());
            Assert.assertSame((Object)SessionAttributePersistenceStrategy.FINE, (Object)configuration.getAttributePersistenceStrategy());
        }
        finally {
            mapper.unregisterRootAttribute(this.schema.getRoot());
        }
    }
}

