/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.EnumSet;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.DefaultSubsystemDescribeHandler;
import org.jboss.as.clustering.controller.DeploymentChainContributingResourceRegistration;
import org.jboss.as.clustering.controller.RequirementCapability;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SubsystemResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.web.service.WebDefaultProviderRequirement;
import org.wildfly.clustering.web.service.WebProviderRequirement;
import org.wildfly.extension.clustering.web.DistributableWebExtension;
import org.wildfly.extension.clustering.web.DistributableWebResourceServiceHandler;
import org.wildfly.extension.clustering.web.HotRodSSOManagementResourceDefinition;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSSOManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.LocalRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentParsingProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentSchema;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentXMLReader;

public class DistributableWebResourceDefinition
extends SubsystemResourceDefinition<SubsystemRegistration>
implements Consumer<DeploymentProcessorTarget> {
    static final PathElement PATH = DistributableWebResourceDefinition.pathElement((String)"distributable-web");

    DistributableWebResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)DistributableWebExtension.SUBSYSTEM_RESOLVER);
    }

    public void register(SubsystemRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubsystemModel((ResourceDefinition)this);
        new DefaultSubsystemDescribeHandler().register(registration);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(Capability.class).addRequiredSingletonChildren(new PathElement[]{LocalRoutingProviderResourceDefinition.PATH});
        DistributableWebResourceServiceHandler handler = new DistributableWebResourceServiceHandler();
        new DeploymentChainContributingResourceRegistration(descriptor, (ResourceServiceHandler)handler, (Consumer)this).register(registration);
        new LocalRoutingProviderResourceDefinition().register(registration);
        new InfinispanRoutingProviderResourceDefinition().register(registration);
        new InfinispanSessionManagementResourceDefinition().register(registration);
        new InfinispanSSOManagementResourceDefinition().register(registration);
        new HotRodSessionManagementResourceDefinition().register(registration);
        new HotRodSSOManagementResourceDefinition().register(registration);
    }

    @Override
    public void accept(DeploymentProcessorTarget target) {
        JBossAllXmlParserRegisteringProcessor.Builder builder = JBossAllXmlParserRegisteringProcessor.builder();
        for (DistributableWebDeploymentSchema schema : EnumSet.allOf(DistributableWebDeploymentSchema.class)) {
            builder.addParser(schema.getRoot(), DistributableWebDeploymentDependencyProcessor.CONFIGURATION_KEY, (JBossAllXMLParser)new DistributableWebDeploymentXMLReader(schema));
        }
        target.addDeploymentProcessor("distributable-web", Phase.STRUCTURE, 2589, (DeploymentUnitProcessor)builder.build());
        target.addDeploymentProcessor("distributable-web", Phase.PARSE, 19201, (DeploymentUnitProcessor)new DistributableWebDeploymentParsingProcessor());
        target.addDeploymentProcessor("distributable-web", Phase.DEPENDENCIES, 288, (DeploymentUnitProcessor)new DistributableWebDeploymentDependencyProcessor());
        target.addDeploymentProcessor("distributable-web", Phase.CONFIGURE_MODULE, 400, (DeploymentUnitProcessor)new DistributableWebDeploymentProcessor());
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        DEFAULT_SESSION_MANAGEMENT("default-session-management", ModelType.STRING, (CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.DEFAULT_SESSION_MANAGEMENT_PROVIDER, (UnaryRequirement)WebProviderRequirement.SESSION_MANAGEMENT_PROVIDER)),
        DEFAULT_SSO_MANAGEMENT("default-single-sign-on-management", ModelType.STRING, (CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.DEFAULT_SSO_MANAGEMENT_PROVIDER, (UnaryRequirement)WebProviderRequirement.SSO_MANAGEMENT_PROVIDER));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, CapabilityReferenceRecorder reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(false)).setRequired(true)).setCapabilityReference(reference)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements CapabilityProvider
    {
        DEFAULT_SESSION_MANAGEMENT_PROVIDER((Requirement)WebDefaultProviderRequirement.SESSION_MANAGEMENT_PROVIDER),
        DEFAULT_SSO_MANAGEMENT_PROVIDER((Requirement)WebDefaultProviderRequirement.SSO_MANAGEMENT_PROVIDER);

        private final org.jboss.as.clustering.controller.Capability capability;

        private Capability(Requirement requirement) {
            this.capability = new RequirementCapability(requirement);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }
}

