/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.SessionAttributes;
import org.wildfly.clustering.web.hotrod.session.SessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesEntry;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineSessionAttributesFactory<K, V>
implements SessionAttributesFactory<K, SessionAttributeNamesEntry> {
    private final RemoteCache<SessionAttributeNamesKey<K>, SessionAttributeNamesEntry> namesCache;
    private final RemoteCache<SessionAttributeKey<K>, V> attributeCache;
    private final Marshaller<Object, V> marshaller;
    private final Function<K, SessionAttributeNamesKey<K>> attributeNamesKeyFactory;
    private final BiFunction<K, Integer, SessionAttributeKey<K>> attributeKeyFactory;

    public FineSessionAttributesFactory(RemoteCache<SessionAttributeNamesKey<K>, SessionAttributeNamesEntry> namesCache, RemoteCache<SessionAttributeKey<K>, V> attributeCache, Marshaller<Object, V> marshaller) {
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.attributeNamesKeyFactory = id -> new SessionAttributeNamesKey<Object>(id);
        this.attributeKeyFactory = (id, attributeId) -> new SessionAttributeKey<Object>(id, (int)attributeId);
    }

    public SessionAttributeNamesEntry createValue(K id, Void context) {
        SessionAttributeNamesEntry entry = new SessionAttributeNamesEntry(new AtomicInteger(), new ConcurrentHashMap<String, Integer>());
        this.namesCache.put(this.attributeNamesKeyFactory.apply(id), (Object)entry);
        return entry;
    }

    public SessionAttributeNamesEntry findValue(K id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.get(this.attributeNamesKeyFactory.apply(id));
        if (entry != null) {
            ConcurrentMap<String, Integer> names = entry.getNames();
            Map attributes = this.attributeCache.getAll(names.values().stream().map(attributeId -> this.attributeKeyFactory.apply(id, (Integer)attributeId)).collect(Collectors.toSet()));
            Predicate<Map.Entry> invalidAttribute = attribute -> {
                Object value = attribute.getValue();
                if (value == null) {
                    Logger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id.toString(), (String)attribute.getKey());
                    return true;
                }
                try {
                    this.marshaller.read(attribute.getValue());
                    return false;
                }
                catch (InvalidSerializedFormException e) {
                    Logger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id.toString(), (String)attribute.getKey());
                    return true;
                }
            };
            if (names.entrySet().stream().map(name -> new AbstractMap.SimpleImmutableEntry(name.getKey(), attributes.get(this.attributeKeyFactory.apply(id, (Integer)name.getValue())))).anyMatch(invalidAttribute)) {
                this.remove(id);
                return null;
            }
        }
        return entry;
    }

    public boolean remove(K id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(this.attributeNamesKeyFactory.apply(id));
        if (entry == null) {
            return false;
        }
        entry.getNames().values().forEach(attributeId -> this.attributeCache.remove(this.attributeKeyFactory.apply(id, (Integer)attributeId)));
        return true;
    }

    @Override
    public SessionAttributes createSessionAttributes(K id, SessionAttributeNamesEntry entry) {
        SessionAttributeNamesKey<K> key = this.attributeNamesKeyFactory.apply(id);
        RemoteCacheEntryMutator mutator = new RemoteCacheEntryMutator(this.namesCache, key, (Object)entry);
        return new FineSessionAttributes<K, V>(id, entry.getSequence(), entry.getNames(), (Mutator)mutator, this.attributeCache, attribute -> this.attributeKeyFactory.apply(id, (Integer)attribute), this.marshaller);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(K id, SessionAttributeNamesEntry entry) {
        return new FineImmutableSessionAttributes<K, V>(id, entry.getNames(), this.attributeCache, attribute -> this.attributeKeyFactory.apply(id, (Integer)attribute), this.marshaller);
    }
}

