/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.coarse;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.SessionAttributes;
import org.wildfly.clustering.web.hotrod.session.SessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class CoarseSessionAttributesFactory<K, V>
implements SessionAttributesFactory<K, Map.Entry<Map<String, Object>, V>> {
    private final RemoteCache<SessionAttributesKey<K>, V> cache;
    private final Function<K, SessionAttributesKey<K>> keyFactory;
    private final Marshaller<Map<String, Object>, V> marshaller;

    public CoarseSessionAttributesFactory(RemoteCache<SessionAttributesKey<K>, V> cache, Marshaller<Map<String, Object>, V> marshaller) {
        this.cache = cache;
        this.keyFactory = id -> new SessionAttributesKey<Object>(id);
        this.marshaller = marshaller;
    }

    public Map.Entry<Map<String, Object>, V> createValue(K id, Void context) {
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        Object value = this.marshaller.write(attributes);
        this.cache.put(this.keyFactory.apply(id), value);
        return new AbstractMap.SimpleImmutableEntry(attributes, value);
    }

    public Map.Entry<Map<String, Object>, V> findValue(K id) {
        Object value = this.cache.get(this.keyFactory.apply(id));
        if (value != null) {
            try {
                Map attributes = (Map)this.marshaller.read(value);
                return new AbstractMap.SimpleImmutableEntry<Map, Object>(attributes, value);
            }
            catch (InvalidSerializedFormException e) {
                Logger.ROOT_LOGGER.failedToActivateSession(e, id.toString());
                this.remove(id);
            }
        }
        return null;
    }

    @Override
    public SessionAttributes createSessionAttributes(K id, Map.Entry<Map<String, Object>, V> entry) {
        SessionAttributesKey<K> key = this.keyFactory.apply(id);
        RemoteCacheEntryMutator mutator = new RemoteCacheEntryMutator(this.cache, key, entry.getValue());
        return new CoarseSessionAttributes(entry.getKey(), (Mutator)mutator, (Marshallability)this.marshaller);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(K id, Map.Entry<Map<String, Object>, V> entry) {
        return new CoarseImmutableSessionAttributes(entry.getKey());
    }

    public boolean remove(K id) {
        this.cache.remove(this.keyFactory.apply(id));
        return true;
    }
}

