/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.web.hotrod.SessionKey;
import org.wildfly.clustering.web.hotrod.SessionKeyExternalizer;

public class IndexedSessionKeyExternalizer<K extends SessionKey<UUID>>
implements Externalizer<K> {
    private final Class<K> targetClass;
    private final ToIntFunction<K> index;
    private final BiFunction<UUID, Integer, K> resolver;

    protected IndexedSessionKeyExternalizer(Class<K> targetClass, ToIntFunction<K> index, BiFunction<UUID, Integer, K> resolver) {
        this.targetClass = targetClass;
        this.index = index;
        this.resolver = resolver;
    }

    public Class<K> getTargetClass() {
        return this.targetClass;
    }

    public K readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        UUID id = (UUID)SessionKeyExternalizer.IDENTIFIER_EXTERNALIZER.readObject(input);
        int index = IndexSerializer.VARIABLE.readInt((DataInput)input);
        return (K)((SessionKey)this.resolver.apply(id, index));
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        SessionKeyExternalizer.IDENTIFIER_EXTERNALIZER.writeObject(output, ((SessionKey)key).getId());
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, this.index.applyAsInt(key));
    }
}

