/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.util.UUID;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodImmutableSession;
import org.wildfly.clustering.web.hotrod.session.HotRodSession;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionEntry;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAttributes;
import org.wildfly.clustering.web.hotrod.session.SessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.SessionEntry;
import org.wildfly.clustering.web.hotrod.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;

public class HotRodSessionFactory<V, L>
implements SessionFactory<UUID, HotRodSessionMetaData<L>, V, L> {
    private final SessionMetaDataFactory<UUID, HotRodSessionMetaData<L>, L> metaDataFactory;
    private final SessionAttributesFactory<UUID, V> attributesFactory;
    private final LocalContextFactory<L> localContextFactory;

    public HotRodSessionFactory(SessionMetaDataFactory<UUID, HotRodSessionMetaData<L>, L> metaDataFactory, SessionAttributesFactory<UUID, V> attributesFactory, LocalContextFactory<L> localContextFactory) {
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.localContextFactory = localContextFactory;
    }

    public SessionEntry<UUID, HotRodSessionMetaData<L>, V> createValue(String id, Void context) {
        HotRodSessionMetaData metaDataValue = (HotRodSessionMetaData)this.metaDataFactory.createValue(id, context);
        if (metaDataValue == null) {
            return null;
        }
        UUID key = metaDataValue.getId();
        Object attributesValue = this.attributesFactory.createValue(key, context);
        return new HotRodSessionEntry<HotRodSessionMetaData, Object>(key, metaDataValue, attributesValue);
    }

    public SessionEntry<UUID, HotRodSessionMetaData<L>, V> findValue(String id) {
        HotRodSessionMetaData metaData = (HotRodSessionMetaData)this.metaDataFactory.findValue(id);
        if (metaData != null) {
            UUID key = metaData.getId();
            Object attributes = this.attributesFactory.findValue(key);
            if (attributes != null) {
                return new HotRodSessionEntry<HotRodSessionMetaData, Object>(key, metaData, attributes);
            }
            this.metaDataFactory.remove(id);
        }
        return null;
    }

    public boolean remove(String id) {
        UUID key = this.metaDataFactory.remove(id);
        if (key == null) {
            return false;
        }
        this.attributesFactory.remove(key);
        return true;
    }

    @Override
    public SessionMetaDataFactory<UUID, HotRodSessionMetaData<L>, L> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public SessionAttributesFactory<UUID, V> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public Session<L> createSession(String id, SessionEntry<UUID, HotRodSessionMetaData<L>, V> entry) {
        HotRodSessionMetaData<L> metaDataValue = entry.getMetaDataValue();
        InvalidatableSessionMetaData metaData = this.metaDataFactory.createSessionMetaData(id, metaDataValue);
        SessionAttributes attributes = this.attributesFactory.createSessionAttributes((UUID)entry.getId(), entry.getAttributesValue());
        return new HotRodSession<L>(id, metaData, attributes, metaDataValue.getLocalContext(), this.localContextFactory, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, ImmutableSessionAttributes attributes) {
        return new HotRodImmutableSession(id, metaData, attributes);
    }
}

