/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionCreationMetaData;

public class SessionCreationMetaDataEntryExternalizer
implements Externalizer<SessionCreationMetaDataEntry<Object>> {
    private static final Externalizer<UUID> UUID_EXTERNALIZER = DefaultExternalizer.UUID.cast(UUID.class);
    private static final Externalizer<Instant> INSTANT_EXTERNALIZER = DefaultExternalizer.INSTANT.cast(Instant.class);

    public void writeObject(ObjectOutput output, SessionCreationMetaDataEntry<Object> entry) throws IOException {
        UUID_EXTERNALIZER.writeObject(output, (Object)entry.getId());
        SessionCreationMetaData metaData = entry.getMetaData();
        INSTANT_EXTERNALIZER.writeObject(output, (Object)metaData.getCreationTime());
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, (int)metaData.getMaxInactiveInterval().getSeconds());
    }

    public SessionCreationMetaDataEntry<Object> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        UUID key = (UUID)UUID_EXTERNALIZER.readObject(input);
        Instant created = (Instant)INSTANT_EXTERNALIZER.readObject(input);
        SimpleSessionCreationMetaData metaData = new SimpleSessionCreationMetaData(created);
        metaData.setMaxInactiveInterval(Duration.ofSeconds(IndexSerializer.VARIABLE.readInt((DataInput)input)));
        return new SessionCreationMetaDataEntry<Object>(key, metaData);
    }

    public Class<SessionCreationMetaDataEntry<Object>> getTargetClass() {
        return SessionCreationMetaDataEntry.class;
    }
}

