/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.IdentifierSerializerProvider;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;

public class SessionCreationMetaDataKeyExternalizer
implements Externalizer<SessionCreationMetaDataKey> {
    private static final Serializer<String> SERIALIZER = SessionCreationMetaDataKeyExternalizer.findIdentifierSerializer();

    private static Serializer<String> findIdentifierSerializer() {
        Iterator<IdentifierSerializerProvider> iterator = ServiceLoader.load(IdentifierSerializerProvider.class, IdentifierSerializerProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            IdentifierSerializerProvider provider = iterator.next();
            return provider.getSerializer();
        }
        throw new IllegalStateException();
    }

    public void writeObject(ObjectOutput output, SessionCreationMetaDataKey key) throws IOException {
        output.writeUTF(key.getDeployment());
        SERIALIZER.write((DataOutput)output, key.getId());
    }

    public SessionCreationMetaDataKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String deployment = input.readUTF();
        String sessionId = (String)SERIALIZER.read((DataInput)input);
        return new SessionCreationMetaDataKey(deployment, sessionId);
    }

    public Class<SessionCreationMetaDataKey> getTargetClass() {
        return SessionCreationMetaDataKey.class;
    }
}

