/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.util.AbstractMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.SessionAttributes;
import org.wildfly.clustering.web.hotrod.session.SessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesEntry;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineSessionAttributesFactory<V>
implements SessionAttributesFactory<UUID, SessionAttributeNamesEntry> {
    private final RemoteCache<SessionAttributeNamesKey, SessionAttributeNamesEntry> namesCache;
    private final RemoteCache<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;

    public FineSessionAttributesFactory(RemoteCache<SessionAttributeNamesKey, SessionAttributeNamesEntry> namesCache, RemoteCache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller) {
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
    }

    public SessionAttributeNamesEntry createValue(UUID id, Void context) {
        SessionAttributeNamesEntry entry = new SessionAttributeNamesEntry(new AtomicInteger(), new ConcurrentHashMap<String, Integer>());
        this.namesCache.put((Object)new SessionAttributeNamesKey(id), (Object)entry);
        return entry;
    }

    public SessionAttributeNamesEntry findValue(UUID id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (entry != null) {
            ConcurrentMap<String, Integer> names = entry.getNames();
            Map attributes = this.attributeCache.getAll(names.values().stream().map(attributeId -> new SessionAttributeKey(id, (int)attributeId)).collect(Collectors.toSet()));
            Predicate<Map.Entry> invalidAttribute = attribute -> {
                Object value = attribute.getValue();
                if (value == null) {
                    Logger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id.toString(), (String)attribute.getKey());
                    return true;
                }
                try {
                    this.marshaller.read(attribute.getValue());
                    return false;
                }
                catch (InvalidSerializedFormException e) {
                    Logger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id.toString(), (String)attribute.getKey());
                    return true;
                }
            };
            if (names.entrySet().stream().map(name -> new AbstractMap.SimpleImmutableEntry(name.getKey(), attributes.get(new SessionAttributeKey(id, (Integer)name.getValue())))).anyMatch(invalidAttribute)) {
                this.remove(id);
                return null;
            }
        }
        return entry;
    }

    public boolean remove(UUID id) {
        SessionAttributeNamesEntry entry = (SessionAttributeNamesEntry)this.namesCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)new SessionAttributeNamesKey(id));
        if (entry == null) {
            return false;
        }
        entry.getNames().values().forEach(attributeId -> this.attributeCache.remove((Object)new SessionAttributeKey(id, (int)attributeId)));
        return true;
    }

    @Override
    public SessionAttributes createSessionAttributes(UUID id, SessionAttributeNamesEntry entry) {
        SessionAttributeNamesKey key = new SessionAttributeNamesKey(id);
        RemoteCacheEntryMutator mutator = new RemoteCacheEntryMutator(this.namesCache, (Object)key, (Object)entry);
        return new FineSessionAttributes<V>(id, entry.getSequence(), entry.getNames(), (Mutator)mutator, this.attributeCache, this.marshaller);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(UUID id, SessionAttributeNamesEntry entry) {
        return new FineImmutableSessionAttributes<V>(id, entry.getNames(), this.attributeCache, this.marshaller);
    }
}

