/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.util.UUID;
import javax.servlet.ServletContext;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.hotrod.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManager;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.Scheduler;
import org.wildfly.clustering.web.hotrod.session.SessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.hotrod.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesEntry;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class HotRodSessionManagerFactory<L, C extends Marshallability>
implements SessionManagerFactory<L, Batch> {
    final Registrar<SessionExpirationListener> expirationRegistrar;
    final Scheduler expirationScheduler;
    private final SessionFactory<UUID, HotRodSessionMetaData<L>, ?, L> sessionFactory;

    public HotRodSessionManagerFactory(HotRodSessionManagerFactoryConfiguration<C, L> config) {
        HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(config.getSessionManagerFactoryConfiguration().getDeploymentName(), config.getCache());
        this.sessionFactory = new HotRodSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config), config.getSessionManagerFactoryConfiguration().getLocalContextFactory());
        ExpiredSessionRemover remover = new ExpiredSessionRemover(this.sessionFactory);
        this.expirationRegistrar = remover;
        this.expirationScheduler = new SessionExpirationScheduler(remover);
    }

    public SessionManager<L, Batch> createSessionManager(final SessionManagerConfiguration configuration) {
        HotRodSessionManagerConfiguration config = new HotRodSessionManagerConfiguration(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistrar() {
                return HotRodSessionManagerFactory.this.expirationRegistrar;
            }

            @Override
            public Scheduler getExpirationScheduler() {
                return HotRodSessionManagerFactory.this.expirationScheduler;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            @Override
            public ServletContext getServletContext() {
                return configuration.getServletContext();
            }
        };
        return new HotRodSessionManager(this.sessionFactory, config);
    }

    public void close() {
        this.expirationScheduler.close();
    }

    private SessionAttributesFactory<UUID, ?> createSessionAttributesFactory(HotRodSessionManagerFactoryConfiguration<C, L> configuration) {
        SessionManagerFactoryConfiguration<C, L> config = configuration.getSessionManagerFactoryConfiguration();
        MarshalledValueFactory factory = config.getMarshalledValueFactory();
        Marshallability context = config.getMarshallingContext();
        switch (config.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory((RemoteCache<SessionAttributeNamesKey, SessionAttributeNamesEntry>)configuration.getCache(), configuration.getCache(), new MarshalledValueMarshaller(factory, context));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(configuration.getCache(), new MarshalledValueMarshaller(factory, context));
            }
        }
        throw new IllegalStateException();
    }
}

