/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntFunction;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<V>
implements ImmutableSessionAttributes,
IntFunction<SessionAttributeKey> {
    private final UUID id;
    private final Map<String, Integer> names;
    private final RemoteCache<SessionAttributeKey, V> cache;
    private final Marshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(UUID id, Map<String, Integer> names, RemoteCache<SessionAttributeKey, V> cache, Marshaller<Object, V> marshaller) {
        this.id = id;
        this.names = names;
        this.cache = cache;
        this.marshaller = marshaller;
    }

    @Override
    public SessionAttributeKey apply(int attributeId) {
        return new SessionAttributeKey(this.id, attributeId);
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    public Object getAttribute(String name) {
        Integer attributeId = this.names.get(name);
        return attributeId != null ? this.read(name, this.cache.get((Object)this.apply(attributeId))) : null;
    }

    protected Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw Logger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.id.toString(), name);
        }
    }
}

