/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesEntry;

public class SessionAttributeNamesEntryExternalizer
implements Externalizer<SessionAttributeNamesEntry> {
    public void writeObject(ObjectOutput output, SessionAttributeNamesEntry value) throws IOException {
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, value.getSequence().get());
        ConcurrentMap<String, Integer> names = value.getNames();
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, names.size());
        for (Map.Entry entry : names.entrySet()) {
            output.writeUTF((String)entry.getKey());
            IndexSerializer.VARIABLE.writeInt((DataOutput)output, ((Integer)entry.getValue()).intValue());
        }
    }

    public SessionAttributeNamesEntry readObject(ObjectInput input) throws IOException {
        AtomicInteger sequence = new AtomicInteger(IndexSerializer.VARIABLE.readInt((DataInput)input));
        int size = IndexSerializer.VARIABLE.readInt((DataInput)input);
        ConcurrentHashMap<String, Integer> names = new ConcurrentHashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            names.put(input.readUTF(), IndexSerializer.VARIABLE.readInt((DataInput)input));
        }
        return new SessionAttributeNamesEntry(sequence, names);
    }

    public Class<SessionAttributeNamesEntry> getTargetClass() {
        return SessionAttributeNamesEntry.class;
    }
}

