/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class SimpleImmutableSessionMetaData
implements ImmutableSessionMetaData {
    private final Instant creationTime;
    private final Instant lastAccessedTime;
    private final Duration maxInactiveInterval;

    public SimpleImmutableSessionMetaData(ImmutableSessionMetaData metaData) {
        this.creationTime = metaData.getCreationTime();
        this.lastAccessedTime = metaData.getLastAccessedTime();
        this.maxInactiveInterval = metaData.getMaxInactiveInterval();
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public boolean isNew() {
        return this.getCreationTime().equals(this.getLastAccessedTime());
    }

    public boolean isExpired() {
        Duration maxInactiveInterval = this.getMaxInactiveInterval();
        return !maxInactiveInterval.isZero() ? this.getLastAccessedTime().plus(maxInactiveInterval).isBefore(Instant.now()) : false;
    }
}

