/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;
import org.wildfly.clustering.web.cache.SessionIdentifierSerializer;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;

public class SessionAttributeKeyExternalizer
implements Externalizer<SessionAttributeKey> {
    public void writeObject(ObjectOutput output, SessionAttributeKey key) throws IOException {
        SessionIdentifierSerializer.INSTANCE.write((DataOutput)output, (String)key.getId());
        DefaultExternalizer.UUID.cast(UUID.class).writeObject(output, (Object)key.getAttributeId());
    }

    public SessionAttributeKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String id = SessionIdentifierSerializer.INSTANCE.read(input);
        UUID attributeId = (UUID)DefaultExternalizer.UUID.cast(UUID.class).readObject(input);
        return new SessionAttributeKey(id, attributeId);
    }

    public Class<SessionAttributeKey> getTargetClass() {
        return SessionAttributeKey.class;
    }
}

