/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.sso.coarse;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.hotrod.HotRodConfiguration;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.web.cache.sso.SessionsFactory;
import org.wildfly.clustering.web.cache.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.cache.sso.coarse.SessionFilter;
import org.wildfly.clustering.web.hotrod.sso.coarse.CoarseSessionsKey;
import org.wildfly.clustering.web.hotrod.sso.coarse.SessionsFilter;
import org.wildfly.clustering.web.sso.Sessions;

public class CoarseSessionsFactory<D, S>
implements SessionsFactory<Map<D, S>, D, S> {
    private final SessionsFilter<D, S> filter = new SessionsFilter();
    private final RemoteCache<CoarseSessionsKey, Map<D, S>> cache;
    private final Flag[] ignoreReturnFlags;

    public CoarseSessionsFactory(HotRodConfiguration configuration) {
        this.cache = configuration.getCache();
        this.ignoreReturnFlags = configuration.getIgnoreReturnFlags();
    }

    public Sessions<D, S> createSessions(String ssoId, Map<D, S> value) {
        CoarseSessionsKey key = new CoarseSessionsKey(ssoId);
        RemoteCacheEntryMutator mutator = new RemoteCacheEntryMutator(this.cache, this.ignoreReturnFlags, (Object)key, value);
        return new CoarseSessions(value, (Mutator)mutator);
    }

    public Map<D, S> createValue(String id, Void context) {
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        this.cache.put((Object)new CoarseSessionsKey(id), sessions);
        return sessions;
    }

    public Map<D, S> findValue(String id) {
        return (Map)this.cache.get((Object)new CoarseSessionsKey(id));
    }

    public Map.Entry<String, Map<D, S>> findEntryContaining(S session) {
        SessionFilter filter = new SessionFilter(session);
        RemoteCache<CoarseSessionsKey, Map<D, S>> cache = this.cache;
        try (Stream stream = cache.entrySet().stream();){
            Map.Entry entry = stream.filter(this.filter).map(this.filter).filter((Predicate<S>)filter).findAny().orElse(null);
            AbstractMap.SimpleImmutableEntry<String, Map> simpleImmutableEntry = entry != null ? new AbstractMap.SimpleImmutableEntry<String, Map>((String)((CoarseSessionsKey)((Object)entry.getKey())).getId(), (Map)entry.getValue()) : null;
            return simpleImmutableEntry;
        }
    }

    public boolean remove(String id) {
        this.cache.withFlags(this.ignoreReturnFlags).remove((Object)new CoarseSessionsKey(id));
        return true;
    }
}

