/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.NullValueConverter;
import org.infinispan.iteration.EntryIterable;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.infinispan.RetryingInvoker;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.CancelSchedulerCommand;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.ScheduleSchedulerCommand;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SessionEvictionScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SessionIdentifierFilter;
import org.wildfly.clustering.web.infinispan.session.SimpleImmutableSession;
import org.wildfly.clustering.web.infinispan.session.Time;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;

@Listener(primaryOnly=true)
public class InfinispanSessionManager<V, L>
implements SessionManager<L, TransactionBatch> {
    private final SessionContext context;
    private final Batcher<TransactionBatch> batcher;
    private final Cache<String, ?> cache;
    private final SessionFactory<V, L> factory;
    private final IdentifierFactory<String> identifierFactory;
    private final CommandDispatcherFactory dispatcherFactory;
    private final NodeFactory<Address> nodeFactory;
    private final int maxActiveSessions;
    private volatile Time defaultMaxInactiveInterval = new Time(30L, TimeUnit.MINUTES);
    private final boolean persistent;
    private final Invoker invoker = new RetryingInvoker(new long[]{0L, 10L, 100L});
    private final SessionIdentifierFilter filter = new SessionIdentifierFilter();
    private final Recordable<ImmutableSession> recorder;
    volatile CommandDispatcher<Scheduler> dispatcher;
    private volatile Scheduler scheduler;

    public InfinispanSessionManager(SessionFactory<V, L> factory, InfinispanSessionManagerConfiguration configuration) {
        this.factory = factory;
        this.cache = configuration.getCache();
        this.context = configuration.getSessionContext();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.nodeFactory = configuration.getNodeFactory();
        this.maxActiveSessions = configuration.getMaxActiveSessions();
        this.recorder = configuration.getInactiveSessionRecorder();
        Configuration config = this.cache.getCacheConfiguration();
        this.persistent = config.clustering().cacheMode().isClustered() || config.persistence().usingStores() && !config.persistence().passivation();
    }

    public void start() {
        if (this.recorder != null) {
            this.recorder.reset();
        }
        this.identifierFactory.start();
        final ArrayList<Scheduler> schedulers = new ArrayList<Scheduler>(2);
        schedulers.add(new SessionExpirationScheduler(this.batcher, new ExpiredSessionRemover<V, L>(this.factory)));
        if (this.maxActiveSessions >= 0) {
            schedulers.add(new SessionEvictionScheduler(this.cache.getName() + ".eviction", this.factory, this.dispatcherFactory, this.maxActiveSessions));
        }
        this.scheduler = new Scheduler(){

            @Override
            public void schedule(ImmutableSession session) {
                for (Scheduler scheduler : schedulers) {
                    scheduler.schedule(session);
                }
            }

            @Override
            public void cancel(String sessionId) {
                for (Scheduler scheduler : schedulers) {
                    scheduler.cancel(sessionId);
                }
            }

            @Override
            public void cancel(Locality locality) {
                for (Scheduler scheduler : schedulers) {
                    scheduler.cancel(locality);
                }
            }

            @Override
            public void close() {
                for (Scheduler scheduler : schedulers) {
                    scheduler.close();
                }
            }
        };
        this.dispatcher = this.dispatcherFactory.createCommandDispatcher((Object)(this.cache.getName() + ".schedulers"), (Object)this.scheduler);
        this.cache.addListener((Object)this, (KeyFilter)this.filter);
        this.schedule(this.cache, (Locality)new SimpleLocality(false), (Locality)new ConsistentHashLocality(this.cache));
    }

    public void stop() {
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
        this.scheduler.close();
        this.identifierFactory.stop();
    }

    boolean isPersistent() {
        return this.persistent;
    }

    private void cancel(ImmutableSession session) {
        try {
            this.executeOnPrimaryOwner(session, new CancelSchedulerCommand(session.getId()));
        }
        catch (Exception e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToCancelSession(e, session.getId());
        }
    }

    void schedule(ImmutableSession session) {
        try {
            this.executeOnPrimaryOwner(session, new ScheduleSchedulerCommand(session));
        }
        catch (Exception e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToScheduleSession(e, session.getId());
        }
    }

    private void executeOnPrimaryOwner(final ImmutableSession session, final Command<Void, Scheduler> command) throws Exception {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Node node = InfinispanSessionManager.this.locatePrimaryOwner(session);
                return (Void)InfinispanSessionManager.this.dispatcher.executeOnNode(command, node).get();
            }
        };
        this.invoker.invoke((Callable)task);
    }

    Node locatePrimaryOwner(ImmutableSession session) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        Address address = dist != null ? dist.getPrimaryLocation((Object)session.getId()) : null;
        return address != null ? this.nodeFactory.createNode((Object)address) : this.dispatcherFactory.getGroup().getLocalNode();
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public long getDefaultMaxInactiveInterval(TimeUnit unit) {
        return this.defaultMaxInactiveInterval.convert(unit);
    }

    public void setDefaultMaxInactiveInterval(long value, TimeUnit unit) {
        this.defaultMaxInactiveInterval = new Time(value, unit);
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public boolean containsSession(String id) {
        return this.cache.containsKey((Object)id);
    }

    public Session<L> findSession(String id) {
        Object value = this.factory.findValue(id);
        if (value == null) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        ImmutableSession session = this.factory.createSession(id, value);
        if (session.getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            session.invalidate();
            return null;
        }
        ImmutableSession immutableSession = this.persistent ? this.factory.createImmutableSession(id, value) : session;
        this.cancel(immutableSession);
        if (this.persistent) {
            InfinispanSessionManager.triggerPostActivationEvents(immutableSession);
        }
        return new SchedulableSession(session, immutableSession);
    }

    public Session<L> createSession(String id) {
        Session<L> session = this.factory.createSession(id, this.factory.createValue(id, null));
        Time time = this.defaultMaxInactiveInterval;
        session.getMetaData().setMaxInactiveInterval(time.getValue(), time.getUnit());
        return new SchedulableSession(session, (ImmutableSession)session);
    }

    public ImmutableSession viewSession(String id) {
        Object value = this.factory.findValue(id);
        return value != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, value)) : null;
    }

    public Set<String> getActiveSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD);
    }

    public Set<String> getLocalSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL);
    }

    private Set<String> getSessions(Flag ... flags) {
        HashSet<String> result = new HashSet<String>();
        try (EntryIterable entries = this.cache.getAdvancedCache().withFlags(flags).filterEntries((KeyValueFilter)this.filter);){
            for (CacheEntry entry : entries.converter((Converter)NullValueConverter.getInstance())) {
                result.add((String)entry.getKey());
            }
        }
        return result;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions().size();
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<String, ?> event) {
        if (!event.isPre() && !this.persistent) {
            String id = (String)event.getKey();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was activated", id);
            Object value = this.factory.findValue(id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                InfinispanSessionManager.triggerPostActivationEvents(session);
            }
        }
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<String, ?> event) {
        if (event.isPre() && !this.persistent) {
            String id = (String)event.getKey();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be passivated", id);
            Object value = this.factory.findValue(id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                InfinispanSessionManager.triggerPrePassivationEvents(session);
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<String, ?> event) {
        if (event.isPre()) {
            String id = (String)event.getKey();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be removed", id);
            Object value = this.factory.findValue(id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                ImmutableSessionAttributes attributes = session.getAttributes();
                ImmutableHttpSessionAdapter httpSession = new ImmutableHttpSessionAdapter(session);
                HttpSessionEvent sessionEvent = new HttpSessionEvent((HttpSession)httpSession);
                for (HttpSessionListener listener : this.context.getSessionListeners()) {
                    listener.sessionDestroyed(sessionEvent);
                }
                for (String name : attributes.getAttributeNames()) {
                    Object attribute = attributes.getAttribute(name);
                    if (!(attribute instanceof HttpSessionBindingListener)) continue;
                    HttpSessionBindingListener listener = (HttpSessionBindingListener)attribute;
                    listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, name, attribute));
                }
                if (this.recorder != null) {
                    this.recorder.record((Object)session);
                }
            }
        }
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<String, ?> event) {
        Cache cache = event.getCache();
        Address localAddress = cache.getCacheManager().getAddress();
        ConsistentHashLocality oldLocality = new ConsistentHashLocality(localAddress, event.getConsistentHashAtStart());
        ConsistentHashLocality newLocality = new ConsistentHashLocality(localAddress, event.getConsistentHashAtEnd());
        if (event.isPre()) {
            this.scheduler.cancel((Locality)newLocality);
        } else {
            this.schedule(cache, (Locality)oldLocality, (Locality)newLocality);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(Cache<String, ?> cache, Locality oldLocality, Locality newLocality) {
        try (EntryIterable entries = cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).filterEntries((KeyValueFilter)this.filter);){
            for (CacheEntry entry : entries.converter((Converter)NullValueConverter.getInstance())) {
                String sessionId = (String)entry.getKey();
                if (oldLocality.isLocal((Object)sessionId) || !newLocality.isLocal((Object)sessionId)) continue;
                Batch batch = this.batcher.createBatch();
                try {
                    Object value = this.factory.findValue(sessionId);
                    if (value == null) continue;
                    this.scheduler.schedule(this.factory.createImmutableSession(sessionId, value));
                }
                finally {
                    batch.discard();
                }
            }
        }
    }

    static void triggerPrePassivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = InfinispanSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session));
            for (HttpSessionActivationListener listener : listeners) {
                listener.sessionWillPassivate(event);
            }
        }
    }

    static void triggerPostActivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = InfinispanSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session));
            for (HttpSessionActivationListener listener : listeners) {
                listener.sessionDidActivate(event);
            }
        }
    }

    private static List<HttpSessionActivationListener> findListeners(ImmutableSession session) {
        ImmutableSessionAttributes attributes = session.getAttributes();
        Set names = attributes.getAttributeNames();
        ArrayList<HttpSessionActivationListener> listeners = new ArrayList<HttpSessionActivationListener>(names.size());
        for (String name : names) {
            Object attribute = attributes.getAttribute(name);
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            listeners.add((HttpSessionActivationListener)attribute);
        }
        return listeners;
    }

    private class SchedulableSession
    implements Session<L> {
        private final Session<L> session;
        private final ImmutableSession immutableSession;

        SchedulableSession(Session<L> session, ImmutableSession immutableSession) {
            this.session = session;
            this.immutableSession = immutableSession;
        }

        public String getId() {
            return this.session.getId();
        }

        public SessionMetaData getMetaData() {
            if (!this.isValid()) {
                throw InfinispanWebLogger.ROOT_LOGGER.invalidSession(this.getId());
            }
            return this.session.getMetaData();
        }

        public boolean isValid() {
            return this.session.isValid();
        }

        public void invalidate() {
            this.session.invalidate();
        }

        public SessionAttributes getAttributes() {
            if (!this.isValid()) {
                throw InfinispanWebLogger.ROOT_LOGGER.invalidSession(this.getId());
            }
            return this.session.getAttributes();
        }

        public SessionContext getContext() {
            return this.session.getContext();
        }

        public void close() {
            if (InfinispanSessionManager.this.isPersistent()) {
                InfinispanSessionManager.triggerPrePassivationEvents(this.immutableSession);
            }
            this.session.close();
            InfinispanSessionManager.this.schedule(this.immutableSession);
        }

        public L getLocalContext() {
            return this.session.getLocalContext();
        }
    }
}

