package org.wildfly.clustering.web.infinispan.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-08-25T20:15:58-0500")
public class InfinispanWebLogger_$logger extends DelegatingBasicLogger implements InfinispanWebLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InfinispanWebLogger_$logger.class.getName();
    public InfinispanWebLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void failedToPassivateSession(final Throwable cause, final String sessionId) {
        super.log.logf(FQCN, WARN, cause, failedToPassivateSession$str(), sessionId);
    }
    private static final String failedToPassivateSession = "WFLYCLWEBINF0001: Failed to passivate attributes of session %s";
    protected String failedToPassivateSession$str() {
        return failedToPassivateSession;
    }
    @Override
    public final void failedToPassivateSessionAttribute(final Throwable cause, final String sessionId, final String attribute) {
        super.log.logf(FQCN, WARN, cause, failedToPassivateSessionAttribute$str(), sessionId, attribute);
    }
    private static final String failedToPassivateSessionAttribute = "WFLYCLWEBINF0002: Failed to passivate attribute %2$s of session %1$s";
    protected String failedToPassivateSessionAttribute$str() {
        return failedToPassivateSessionAttribute;
    }
    private static final String invalidSession = "WFLYCLWEBINF0003: Session %s is not valid";
    protected String invalidSession$str() {
        return invalidSession;
    }
    @Override
    public final IllegalStateException invalidSession(final String sessionId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidSession$str(), sessionId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToExpireSession(final Throwable cause, final String sessionId) {
        super.log.logf(FQCN, WARN, cause, failedToExpireSession$str(), sessionId);
    }
    private static final String failedToExpireSession = "WFLYCLWEBINF0004: Failed to expire session %s";
    protected String failedToExpireSession$str() {
        return failedToExpireSession;
    }
    @Override
    public final void failedToCancelSession(final Throwable cause, final String sessionId) {
        super.log.logf(FQCN, DEBUG, cause, failedToCancelSession$str(), sessionId);
    }
    private static final String failedToCancelSession = "WFLYCLWEBINF0005: Failed to cancel expiration/passivation of session %s on primary owner.";
    protected String failedToCancelSession$str() {
        return failedToCancelSession;
    }
    @Override
    public final void failedToScheduleSession(final Throwable cause, final String sessionId) {
        super.log.logf(FQCN, DEBUG, cause, failedToScheduleSession$str(), sessionId);
    }
    private static final String failedToScheduleSession = "WFLYCLWEBINF0006: Failed to schedule expiration/passivation of session %s on primary owner.";
    protected String failedToScheduleSession$str() {
        return failedToScheduleSession;
    }
    @Override
    public final void failedToActivateSession(final Throwable cause, final String sessionId) {
        super.log.logf(FQCN, WARN, cause, failedToActivateSession$str(), sessionId);
    }
    private static final String failedToActivateSession = "WFLYCLWEBINF0007: Failed to activate attributes of session %s";
    protected String failedToActivateSession$str() {
        return failedToActivateSession;
    }
    @Override
    public final void failedToActivateSessionAttribute(final Throwable cause, final String sessionId, final String attribute) {
        super.log.logf(FQCN, WARN, cause, failedToActivateSessionAttribute$str(), sessionId, attribute);
    }
    private static final String failedToActivateSessionAttribute = "WFLYCLWEBINF0008: Failed to activate attribute %2$s of session %1$s";
    protected String failedToActivateSessionAttribute$str() {
        return failedToActivateSessionAttribute;
    }
    private static final String failedToReadSessionAttribute = "WFLYCLWEBINF0009: Failed to read attribute %2$s of session %1$s";
    protected String failedToReadSessionAttribute$str() {
        return failedToReadSessionAttribute;
    }
    @Override
    public final IllegalStateException failedToReadSessionAttribute(final Throwable cause, final String sessionId, final String attribute) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToReadSessionAttribute$str(), sessionId, attribute), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToActivateAuthentication(final Throwable cause, final String ssoId) {
        super.log.logf(FQCN, WARN, cause, failedToActivateAuthentication$str(), ssoId);
    }
    private static final String failedToActivateAuthentication = "WFLYCLWEBINF0010: Failed to activate authentication for single sign on %s";
    protected String failedToActivateAuthentication$str() {
        return failedToActivateAuthentication;
    }
    @Override
    public final void missingSessionAttributeCacheEntry(final String sessionId, final String attribute) {
        super.log.logf(FQCN, WARN, null, missingSessionAttributeCacheEntry$str(), sessionId, attribute);
    }
    private static final String missingSessionAttributeCacheEntry = "WFLYCLWEBINF0011: Session %s is missing cache entry for attribute %s";
    protected String missingSessionAttributeCacheEntry$str() {
        return missingSessionAttributeCacheEntry;
    }
    @Override
    public final void evictionDisabled(final String cacheName) {
        super.log.logf(FQCN, WARN, null, evictionDisabled$str(), cacheName);
    }
    private static final String evictionDisabled = "WFLYCLWEBINF0012: Disabling eviction for cache '%s'. Web session passivation should be configured via <max-active-sessions/> in jboss-web.xml.";
    protected String evictionDisabled$str() {
        return evictionDisabled;
    }
    @Override
    public final void expirationDisabled(final String cacheName) {
        super.log.logf(FQCN, WARN, null, expirationDisabled$str(), cacheName);
    }
    private static final String expirationDisabled = "WFLYCLWEBINF0013: Disabling expiration for cache '%s'. Web session expiration should be configured per §7.5 of the servlet specification.";
    protected String expirationDisabled$str() {
        return expirationDisabled;
    }
}
