/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.web.infinispan.SessionKeyExternalizer;

public class IndexedSessionKeyExternalizer<K extends Key<String>>
implements Externalizer<K> {
    private final Class<K> targetClass;
    private final BiFunction<String, Integer, K> resolver;
    private final ToIntFunction<K> index;

    protected IndexedSessionKeyExternalizer(Class<K> targetClass, ToIntFunction<K> index, BiFunction<String, Integer, K> resolver) {
        this.targetClass = targetClass;
        this.index = index;
        this.resolver = resolver;
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        SessionKeyExternalizer.SESSION_ID_SERIALIZER.write((DataOutput)output, key.getValue());
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, this.index.applyAsInt(key));
    }

    public K readObject(ObjectInput input) throws IOException {
        String id = (String)SessionKeyExternalizer.SESSION_ID_SERIALIZER.read((DataInput)input);
        int index = IndexSerializer.VARIABLE.readInt((DataInput)input);
        return (K)((Key)this.resolver.apply(id, index));
    }

    public Class<K> getTargetClass() {
        return this.targetClass;
    }
}

