/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.IdentifierSerializerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum SessionIdentifierSerializer implements Serializer<String>
{
    INSTANCE;

    private final Serializer<String> serializer = SessionIdentifierSerializer.loadSerializer();

    private static Serializer<String> loadSerializer() {
        Iterator<IdentifierSerializerProvider> providers = SessionIdentifierSerializer.load(IdentifierSerializerProvider.class).iterator();
        if (!providers.hasNext()) {
            throw new ServiceConfigurationError(IdentifierSerializerProvider.class.getName());
        }
        return providers.next().getSerializer();
    }

    private static <T> Iterable<T> load(final Class<T> providerClass) {
        PrivilegedAction action = new PrivilegedAction<Iterable<T>>(){

            @Override
            public Iterable<T> run() {
                return ServiceLoader.load(providerClass, providerClass.getClassLoader());
            }
        };
        return (Iterable)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    public void write(DataOutput output, String value) throws IOException {
        this.serializer.write(output, (Object)value);
    }

    public String read(DataInput input) throws IOException {
        return (String)this.serializer.read(input);
    }
}

