/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import org.infinispan.remoting.transport.Address;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.distribution.KeyDistribution;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.server.NodeFactory;
import org.wildfly.clustering.web.infinispan.routing.RankedRouteLocator;

public class RankedRouteLocatorTestCase {
    @Test
    public void test() {
        KeyDistribution distribution = (KeyDistribution)Mockito.mock(KeyDistribution.class);
        NodeFactory factory = (NodeFactory)Mockito.mock(NodeFactory.class);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Group group = (Group)Mockito.mock(Group.class);
        Address owner1 = (Address)Mockito.mock(Address.class);
        Address owner2 = (Address)Mockito.mock(Address.class);
        Address owner3 = (Address)Mockito.mock(Address.class);
        Address owner4 = (Address)Mockito.mock(Address.class);
        Address unregistered = (Address)Mockito.mock(Address.class);
        Address local = (Address)Mockito.mock(Address.class);
        Node member1 = (Node)Mockito.mock(Node.class);
        Node member2 = (Node)Mockito.mock(Node.class);
        Node member3 = (Node)Mockito.mock(Node.class);
        Node member4 = (Node)Mockito.mock(Node.class);
        Node unregisteredMember = (Node)Mockito.mock(Node.class);
        Node localMember = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)registry.getGroup()).thenReturn((Object)group);
        Mockito.when((Object)group.getLocalMember()).thenReturn((Object)localMember);
        Mockito.when((Object)registry.getEntry(member1)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, Object>("member1", null));
        Mockito.when((Object)registry.getEntry(member2)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, Object>("member2", null));
        Mockito.when((Object)registry.getEntry(member3)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, Object>("member3", null));
        Mockito.when((Object)registry.getEntry(member4)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, Object>("member4", null));
        Mockito.when((Object)registry.getEntry(localMember)).thenReturn(new AbstractMap.SimpleImmutableEntry<String, Object>("local", null));
        Mockito.when((Object)registry.getEntry(unregisteredMember)).thenReturn(null);
        Mockito.when((Object)factory.createNode((Object)owner1)).thenReturn((Object)member1);
        Mockito.when((Object)factory.createNode((Object)owner2)).thenReturn((Object)member2);
        Mockito.when((Object)factory.createNode((Object)owner3)).thenReturn((Object)member3);
        Mockito.when((Object)factory.createNode((Object)owner4)).thenReturn((Object)member4);
        Mockito.when((Object)factory.createNode((Object)local)).thenReturn((Object)localMember);
        Mockito.when((Object)factory.createNode((Object)unregistered)).thenReturn((Object)unregisteredMember);
        RankedRouteLocator locator = new RankedRouteLocator(distribution, registry, factory, ".", 3);
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(owner1, owner2, owner3, owner4));
        Assert.assertEquals((Object)"member1.member2.member3", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(owner1, owner2, owner3, local));
        Assert.assertEquals((Object)"member1.member2.member3", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(owner1, owner2, unregistered, owner4));
        Assert.assertEquals((Object)"member1.member2.member4", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(owner1, local, owner3));
        Assert.assertEquals((Object)"member1.local.member3", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(owner1, owner2));
        Assert.assertEquals((Object)"member1.member2.local", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(local, owner2));
        Assert.assertEquals((Object)"local.member2", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(owner1));
        Assert.assertEquals((Object)"member1.local", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(local));
        Assert.assertEquals((Object)"local", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Arrays.asList(unregistered));
        Assert.assertEquals((Object)"local", (Object)locator.locate("key"));
        Mockito.when((Object)distribution.getOwners((Object)new GroupedKey((Object)"key"))).thenReturn(Collections.emptyList());
        Assert.assertEquals((Object)"local", (Object)locator.locate("key"));
    }
}

