/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.web.cache.session.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class SessionExpirationSchedulerTestCase {
    @Test
    public void test() throws InterruptedException {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        Remover remover = (Remover)Mockito.mock(Remover.class);
        ImmutableSessionMetaDataFactory metaDataFactory = (ImmutableSessionMetaDataFactory)Mockito.mock(ImmutableSessionMetaDataFactory.class);
        ImmutableSessionMetaData immortalSessionMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSessionMetaData expiringSessionMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSessionMetaData canceledSessionMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        String immortalSessionId = "immortal";
        String expiringSessionId = "expiring";
        String canceledSessionId = "canceled";
        Mockito.when((Object)((TransactionBatch)batcher.createBatch())).thenReturn((Object)batch);
        Mockito.when((Object)immortalSessionMetaData.getMaxInactiveInterval()).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)expiringSessionMetaData.getMaxInactiveInterval()).thenReturn((Object)Duration.ofMillis(1L));
        Mockito.when((Object)canceledSessionMetaData.getMaxInactiveInterval()).thenReturn((Object)Duration.ofSeconds(100L));
        Instant now = Instant.now();
        Mockito.when((Object)expiringSessionMetaData.getLastAccessEndTime()).thenReturn((Object)now);
        Mockito.when((Object)canceledSessionMetaData.getLastAccessEndTime()).thenReturn((Object)now);
        Mockito.when((Object)remover.remove((Object)expiringSessionId)).thenReturn((Object)true);
        try (SessionExpirationScheduler scheduler = new SessionExpirationScheduler(batcher, metaDataFactory, remover, Duration.ZERO);){
            scheduler.schedule((Object)immortalSessionId, (Object)immortalSessionMetaData);
            scheduler.schedule((Object)canceledSessionId, (Object)canceledSessionMetaData);
            scheduler.schedule((Object)expiringSessionId, (Object)expiringSessionMetaData);
            scheduler.cancel((Object)canceledSessionId);
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        ((Remover)Mockito.verify((Object)remover, (VerificationMode)Mockito.never())).remove((Object)immortalSessionId);
        ((Remover)Mockito.verify((Object)remover, (VerificationMode)Mockito.never())).remove((Object)canceledSessionId);
        ((TransactionBatch)Mockito.verify((Object)batch)).close();
    }
}

