/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.infinispan.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.distribution.Locality;
import org.wildfly.clustering.infinispan.notifications.PredicateKeyFilter;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.SimpleImmutableSession;
import org.wildfly.clustering.web.cache.session.ValidSession;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionExpirationMetaData;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionExpirationMetaData;
import org.wildfly.clustering.web.session.SessionManager;

@Listener(primaryOnly=true)
public class InfinispanSessionManager<SC, MV, AV, LC>
implements SessionManager<LC, TransactionBatch> {
    private final Registrar<SessionExpirationListener> expirationRegistrar;
    private final SessionExpirationListener expirationListener;
    private final Batcher<TransactionBatch> batcher;
    private final Cache<Key<String>, ?> cache;
    private final CacheProperties properties;
    private final SessionFactory<SC, MV, AV, LC> factory;
    private final IdentifierFactory<String> identifierFactory;
    private final Scheduler<String, SessionExpirationMetaData> expirationScheduler;
    private final Recordable<ImmutableSessionMetaData> recorder;
    private final SC context;
    private final Runnable startTask;
    private final Consumer<ImmutableSession> closeTask;
    private final Registrar<Map.Entry<SC, SessionManager<LC, TransactionBatch>>> contextRegistrar;
    private volatile Duration defaultMaxInactiveInterval = Duration.ofMinutes(30L);
    private volatile Registration expirationRegistration;
    private volatile Registration contextRegistration;

    public InfinispanSessionManager(SessionFactory<SC, MV, AV, LC> factory, final InfinispanSessionManagerConfiguration<SC, LC> configuration) {
        this.factory = factory;
        this.cache = configuration.getCache();
        this.properties = configuration.getProperties();
        this.expirationRegistrar = configuration.getExpirationRegistar();
        this.expirationListener = configuration.getExpirationListener();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
        this.expirationScheduler = configuration.getExpirationScheduler();
        this.recorder = configuration.getInactiveSessionRecorder();
        this.context = configuration.getServletContext();
        this.contextRegistrar = configuration.getContextRegistrar();
        this.startTask = configuration.getStartTask();
        this.closeTask = new Consumer<ImmutableSession>(){

            @Override
            public void accept(ImmutableSession session) {
                if (session.isValid()) {
                    configuration.getExpirationScheduler().schedule((Object)session.getId(), (Object)new SimpleSessionExpirationMetaData((SessionExpirationMetaData)session.getMetaData()));
                }
            }
        };
    }

    public void start() {
        this.contextRegistration = this.contextRegistrar.register(new AbstractMap.SimpleImmutableEntry<SC, InfinispanSessionManager>(this.context, this));
        if (this.recorder != null) {
            this.recorder.reset();
            this.cache.addListener((Object)this, (CacheEventFilter)new PredicateKeyFilter((Predicate)((Object)SessionCreationMetaDataKeyFilter.INSTANCE)), null);
        }
        this.identifierFactory.start();
        this.expirationRegistration = this.expirationRegistrar.register((Object)this.expirationListener);
        this.startTask.run();
    }

    public void stop() {
        PersistenceConfiguration persistence;
        if (!this.properties.isPersistent() && (persistence = this.cache.getCacheConfiguration().persistence()).passivation() && !persistence.stores().stream().allMatch(StoreConfiguration::purgeOnStartup)) {
            try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING}).keySet().stream();){
                stream.filter(SessionCreationMetaDataKeyFilter.INSTANCE).forEach(arg_0 -> this.cache.evict(arg_0));
            }
        }
        this.expirationRegistration.close();
        if (this.recorder != null) {
            this.cache.removeListener((Object)this);
        }
        this.identifierFactory.stop();
        this.contextRegistration.close();
    }

    public Duration getStopTimeout() {
        return Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout());
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Duration getDefaultMaxInactiveInterval() {
        return this.defaultMaxInactiveInterval;
    }

    public void setDefaultMaxInactiveInterval(Duration duration) {
        this.defaultMaxInactiveInterval = duration;
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Session<LC> findSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue((Object)id);
        if (value == null) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        ImmutableSession session = this.factory.createImmutableSession(id, value);
        if (session.getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            this.expirationListener.sessionExpired(session);
            this.factory.remove((Object)id);
            return null;
        }
        this.expirationScheduler.cancel((Object)id);
        return new ValidSession(this.factory.createSession(id, value, this.context), this.closeTask);
    }

    public Session<LC> createSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.createValue((Object)id, null);
        if (entry == null) {
            return null;
        }
        Session session = this.factory.createSession(id, entry, this.context);
        session.getMetaData().setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        return new ValidSession(session, this.closeTask);
    }

    public ImmutableSession readSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue((Object)id);
        return value != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, value)) : null;
    }

    public Set<String> getActiveSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD);
    }

    public Set<String> getLocalSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL);
    }

    private Set<String> getSessions(Flag ... flags) {
        CacheLocality locality = new CacheLocality(this.cache);
        try (CacheStream keys = this.cache.getAdvancedCache().withFlags(flags).keySet().stream();){
            Set<String> set = keys.filter(SessionCreationMetaDataKeyFilter.INSTANCE.and(arg_0 -> InfinispanSessionManager.lambda$getSessions$0((Locality)locality, arg_0))).map(key -> (String)key.getId()).collect(Collectors.toSet());
            return set;
        }
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions().size();
    }

    @CacheEntryRemoved
    public CompletionStage<Void> removed(CacheEntryRemovedEvent<SessionCreationMetaDataKey, ?> event) {
        if (event.isPre()) {
            String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getId();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be removed", id);
            SessionMetaDataFactory factory = this.factory.getMetaDataFactory();
            Object value = factory.tryValue((Object)id);
            if (value != null) {
                ImmutableSessionMetaData metaData = factory.createImmutableSessionMetaData(id, value);
                this.recorder.record((Object)metaData);
            }
        }
        return CompletableFutures.completedNull();
    }

    private static /* synthetic */ boolean lambda$getSessions$0(Locality locality, Object key) {
        return locality.isLocal(key);
    }
}

