/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.InfinispanWebMessages;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class InfinispanSession<L>
extends InfinispanImmutableSession
implements Session<L> {
    private final SessionMetaData metaData;
    private final SessionAttributes attributes;
    private final AtomicReference<L> localContext;
    private final LocalContextFactory<L> localContextFactory;
    private final Mutator mutator;
    private final Remover<String> remover;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public InfinispanSession(String id, SessionMetaData metaData, SessionAttributes attributes, AtomicReference<L> localContext, LocalContextFactory<L> localContextFactory, SessionContext context, Mutator mutator, Remover<String> remover) {
        super(id, (ImmutableSessionMetaData)metaData, (ImmutableSessionAttributes)attributes, context);
        this.metaData = metaData;
        this.attributes = attributes;
        this.localContext = localContext;
        this.localContextFactory = localContextFactory;
        this.mutator = mutator;
        this.remover = remover;
    }

    public SessionAttributes getAttributes() {
        if (!this.valid.get()) {
            throw InfinispanWebMessages.MESSAGES.invalidSession(this.getId());
        }
        return this.attributes;
    }

    public void invalidate() {
        if (!this.valid.compareAndSet(true, false)) {
            throw InfinispanWebMessages.MESSAGES.invalidSession(this.getId());
        }
        this.remover.remove((Object)this.getId());
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    public SessionMetaData getMetaData() {
        if (!this.valid.get()) {
            throw InfinispanWebMessages.MESSAGES.invalidSession(this.getId());
        }
        return this.metaData;
    }

    public void close() {
        if (this.valid.get()) {
            this.metaData.setLastAccessedTime(new Date());
            this.mutator.mutate();
        }
    }

    public L getLocalContext() {
        if (this.localContextFactory == null) {
            return null;
        }
        Object localContext = this.localContext.get();
        if (localContext == null && !this.localContext.compareAndSet(null, localContext = this.localContextFactory.createLocalContext())) {
            return this.localContext.get();
        }
        return localContext;
    }
}

