/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshalledValueFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContextFactory;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.spi.CacheServiceNames;
import org.wildfly.clustering.spi.ChannelServiceNames;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.MarshalledValueSessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshallingContext;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesCacheKey;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionFactory;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class InfinispanSessionManagerFactory
extends AbstractService<SessionManagerFactory<TransactionBatch>>
implements SessionManagerFactory<TransactionBatch> {
    private final SessionManagerConfiguration config;
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();
    private final InjectedValue<NodeFactory> nodeFactory = new InjectedValue();

    public static ServiceBuilder<SessionManagerFactory<TransactionBatch>> build(ServiceTarget target, ServiceName name, String containerName, String cacheName, SessionManagerConfiguration config) {
        InfinispanSessionManagerFactory factory = new InfinispanSessionManagerFactory(config);
        return target.addService(name, (Service)factory).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, factory.cache).addDependency(KeyAffinityServiceFactoryService.getServiceName((String)containerName), KeyAffinityServiceFactory.class, factory.affinityFactory).addDependency(ChannelServiceNames.COMMAND_DISPATCHER.getServiceName(containerName), CommandDispatcherFactory.class, factory.dispatcherFactory).addDependency(CacheServiceNames.NODE_FACTORY.getServiceName(containerName), NodeFactory.class, factory.nodeFactory);
    }

    private InfinispanSessionManagerFactory(SessionManagerConfiguration config) {
        this.config = config;
    }

    public SessionManagerFactory getValue() {
        return this;
    }

    public <L> SessionManager<L, TransactionBatch> createSessionManager(final SessionContext context, IdentifierFactory<String> identifierFactory, LocalContextFactory<L> localContextFactory) {
        InfinispanBatcher batcher = new InfinispanBatcher((Cache)this.cache.getValue());
        final AffinityIdentifierFactory<String> factory = new AffinityIdentifierFactory<String>(identifierFactory, (Cache)this.cache.getValue(), (KeyAffinityServiceFactory)this.affinityFactory.getValue());
        final Cache cache = (Cache)this.cache.getValue();
        CommandDispatcherFactory dispatcherFactory = (CommandDispatcherFactory)this.dispatcherFactory.getValue();
        NodeFactory nodeFactory = (NodeFactory)this.nodeFactory.getValue();
        int maxActiveSessions = this.config.getMaxActiveSessions();
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration((Batcher)batcher, dispatcherFactory, nodeFactory, maxActiveSessions){
            final /* synthetic */ Batcher val$batcher;
            final /* synthetic */ CommandDispatcherFactory val$dispatcherFactory;
            final /* synthetic */ NodeFactory val$nodeFactory;
            final /* synthetic */ int val$maxActiveSessions;
            {
                this.val$batcher = batcher;
                this.val$dispatcherFactory = commandDispatcherFactory;
                this.val$nodeFactory = nodeFactory;
                this.val$maxActiveSessions = n;
            }

            @Override
            public SessionContext getSessionContext() {
                return context;
            }

            @Override
            public Cache<String, ?> getCache() {
                return cache;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return this.val$batcher;
            }

            @Override
            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$dispatcherFactory;
            }

            @Override
            public NodeFactory<Address> getNodeFactory() {
                return this.val$nodeFactory;
            }

            @Override
            public int getMaxActiveSessions() {
                return this.val$maxActiveSessions;
            }
        };
        return new InfinispanSessionManager(this.getSessionFactory(context, localContextFactory), config);
    }

    private <L> SessionFactory<?, L> getSessionFactory(SessionContext context, LocalContextFactory<L> localContextFactory) {
        Module module = this.config.getModule();
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)new SessionAttributeMarshallingContext(module), (ClassLoader)module.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        switch (this.config.getAttributePersistenceStrategy()) {
            case FINE: {
                Cache sessionCache = (Cache)this.cache.getValue();
                Cache attributeCache = (Cache)this.cache.getValue();
                MarshalledValueSessionAttributeMarshaller marshaller = new MarshalledValueSessionAttributeMarshaller((MarshalledValueFactory<SimpleMarshallingContext>)factory, marshallingContext);
                return new FineSessionFactory<L>(sessionCache, (Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>>)attributeCache, context, marshaller, localContextFactory);
            }
            case COARSE: {
                Cache sessionCache = (Cache)this.cache.getValue();
                Cache attributesCache = (Cache)this.cache.getValue();
                MarshalledValueSessionAttributeMarshaller marshaller = new MarshalledValueSessionAttributeMarshaller((MarshalledValueFactory<SimpleMarshallingContext>)factory, marshallingContext);
                return new CoarseSessionFactory<L>(sessionCache, (Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>>)attributesCache, context, marshaller, localContextFactory);
            }
        }
        throw new IllegalStateException();
    }
}

