/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.Map;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.web.infinispan.session.MutableDetector;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.session.SessionAttributes;

public class CoarseSessionAttributes
extends CoarseImmutableSessionAttributes
implements SessionAttributes {
    private final Mutator mutator;

    public CoarseSessionAttributes(MarshalledValue<Map<String, Object>, MarshallingContext> attributes, SessionAttributeMarshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> marshaller, Mutator mutator) {
        super(attributes, marshaller);
        this.mutator = mutator;
    }

    public Object removeAttribute(String name) {
        Object value = this.getAttributes().remove(name);
        this.mutator.mutate();
        return value;
    }

    public Object setAttribute(String name, Object value) {
        Map<String, Object> attributes = this.getAttributes();
        Object old = value != null ? attributes.put(name, value) : attributes.remove(name);
        this.mutator.mutate();
        return old;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (MutableDetector.isMutable(value)) {
            this.mutator.mutate();
        }
        return value;
    }
}

