/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Set;
import org.infinispan.Cache;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<V>
implements ImmutableSessionAttributes {
    private final String id;
    private final Set<String> attributes;
    private final Cache<SessionAttributeCacheKey, V> cache;
    private final SessionAttributeMarshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(String id, Set<String> attributes, Cache<SessionAttributeCacheKey, V> attributeCache, SessionAttributeMarshaller<Object, V> marshaller) {
        this.id = id;
        this.attributes = attributes;
        this.cache = attributeCache;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        V value = this.getAttributeValue(this.createKey(name));
        return value != null ? this.marshaller.read(value) : null;
    }

    protected V getAttributeValue(SessionAttributeCacheKey key) {
        return (V)this.cache.get((Object)key);
    }

    protected SessionAttributeCacheKey createKey(String attribute) {
        return new SessionAttributeCacheKey(this.id, attribute);
    }
}

