/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;

public class SessionManagerRegistryBuilder
implements Builder<SessionManagerRegistry>,
Service<SessionManagerRegistry>,
SessionManagerRegistry,
UndertowEventListener {
    private final ServiceName hostServiceName;
    private final InjectedValue<UndertowService> service = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<SessionListener> listener = new InjectedValue();
    private final ConcurrentMap<String, SessionManager> managers = new ConcurrentHashMap<String, SessionManager>();
    private final ServiceName listenerServiceName;

    public SessionManagerRegistryBuilder(ServiceName hostServiceName, ServiceName listenerServiceName) {
        this.hostServiceName = hostServiceName;
        this.listenerServiceName = listenerServiceName;
    }

    public ServiceName getServiceName() {
        return this.hostServiceName.append(new String[]{"managers"});
    }

    public ServiceBuilder<SessionManagerRegistry> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)this).addDependency(UndertowService.UNDERTOW, UndertowService.class, this.service).addDependency(this.hostServiceName, Host.class, this.host).addDependency(this.listenerServiceName, SessionListener.class, this.listener).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public SessionManagerRegistry getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ((UndertowService)this.service.getValue()).registerListener((UndertowEventListener)this);
        ((Host)this.host.getValue()).getDeployments().forEach(deployment -> this.addDeployment((Deployment)deployment));
    }

    public void stop(StopContext context) {
        ((Host)this.host.getValue()).getDeployments().forEach(deployment -> this.removeDeployment((Deployment)deployment));
        ((UndertowService)this.service.getValue()).unregisterListener((UndertowEventListener)this);
    }

    private void addDeployment(Deployment deployment) {
        SessionManager manager = deployment.getSessionManager();
        if (this.managers.putIfAbsent(deployment.getDeploymentInfo().getDeploymentName(), deployment.getSessionManager()) == null) {
            manager.registerSessionListener((SessionListener)this.listener.getValue());
        }
    }

    private void removeDeployment(Deployment deployment) {
        if (this.managers.remove(deployment.getDeploymentInfo().getDeploymentName()) != null) {
            deployment.getSessionManager().removeSessionListener((SessionListener)this.listener.getValue());
        }
    }

    public void onDeploymentStart(Deployment deployment, Host host) {
        if (((Host)this.host.getValue()).getName().equals(host.getName())) {
            this.addDeployment(deployment);
        }
    }

    public void onDeploymentStop(Deployment deployment, Host host) {
        if (((Host)this.host.getValue()).getName().equals(host.getName())) {
            this.removeDeployment(deployment);
        }
    }

    @Override
    public SessionManager getSessionManager(String deployment) {
        return (SessionManager)this.managers.get(deployment);
    }
}

