/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.core.InMemorySessionManagerFactory;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.SimpleCapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactoryBuilder;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;

public class DistributableSessionManagerFactoryBuilderProvider
implements org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilderProvider {
    private static final Optional<SessionManagerFactoryBuilderProvider> PROVIDER = StreamSupport.stream(ServiceLoader.load(SessionManagerFactoryBuilderProvider.class, SessionManagerFactoryBuilderProvider.class.getClassLoader()).spliterator(), false).findFirst();

    public CapabilityServiceBuilder<SessionManagerFactory> getBuilder(ServiceName name, DistributableSessionManagerConfiguration configuration) {
        Optional<DistributableSessionManagerFactoryBuilder> builder = PROVIDER.map(provider -> new DistributableSessionManagerFactoryBuilder(name, configuration, (SessionManagerFactoryBuilderProvider<Batch>)provider));
        return builder.orElseGet(() -> {
            UndertowLogger.ROOT_LOGGER.clusteringNotSupported();
            return new SimpleCapabilityServiceBuilder(name, (Object)new InMemorySessionManagerFactory(configuration.getMaxActiveSessions()));
        });
    }
}

